/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.beams.common.modules.targeting;

import io.github.davidqf555.minecraft.beams.common.blocks.te.TurretTileEntity;
import io.github.davidqf555.minecraft.beams.common.entities.BeamEntity;
import io.github.davidqf555.minecraft.beams.common.modules.targeting.TargetingModuleType;
import java.util.Comparator;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class EntityTargetingType
implements TargetingModuleType {
    private final Predicate<Entity> condition;

    public EntityTargetingType(Predicate<Entity> condition) {
        this.condition = condition;
    }

    @Override
    @Nullable
    public Vec3 tick(TurretTileEntity te, double range) {
        Level world = te.m_58904_();
        AABB bounds = AABB.m_165882_((Vec3)Vec3.m_82528_((Vec3i)te.m_58899_()), (double)(range * 2.0), (double)(range * 2.0), (double)(range * 2.0));
        Vec3 center = Vec3.m_82512_((Vec3i)te.m_58899_());
        return world.m_6249_((Entity)null, bounds, this.condition.and(EntitySelector.f_20406_).and(entity -> !(entity instanceof BeamEntity))).stream().filter(entity -> entity.m_20238_(center) <= range * range).filter(entity -> this.canSee(world, center, (Entity)entity)).min(Comparator.comparingDouble(entity -> entity.m_20238_(center))).map(entity -> entity.m_20299_(1.0f)).orElse(null);
    }

    private boolean canSee(Level world, Vec3 start, Entity entity) {
        BlockHitResult result = world.m_45547_(new ClipContext(start, entity.m_20299_(1.0f), ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, null));
        return result.m_6662_() == HitResult.Type.MISS;
    }
}

