/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.beams.common.modules;

import io.github.davidqf555.minecraft.beams.common.entities.BeamEntity;
import io.github.davidqf555.minecraft.beams.common.modules.ProjectorModuleType;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;

public class FreezeModuleType
extends ProjectorModuleType {
    private final Function<Integer, Integer> amp;
    private final Function<Integer, Integer> duration;
    private final Function<Integer, Integer> freeze;

    public FreezeModuleType(Function<Integer, Integer> amp, Function<Integer, Integer> duration, Function<Integer, Integer> freeze) {
        this.amp = amp;
        this.duration = duration;
        this.freeze = freeze;
    }

    @Override
    public void onEntityTick(BeamEntity beam, Entity target, int amt) {
        if (target.m_142079_()) {
            target.m_146917_(target.m_146888_() + this.freeze.apply(amt) + 2);
        }
        if (target instanceof LivingEntity) {
            ((LivingEntity)target).m_7292_(new MobEffectInstance(MobEffects.f_19597_, this.duration.apply(amt).intValue(), this.amp.apply(amt) - 1));
            ((LivingEntity)target).m_7292_(new MobEffectInstance(MobEffects.f_19599_, this.duration.apply(amt).intValue(), this.amp.apply(amt) - 1));
        }
    }

    @Override
    public void onBlockTick(BeamEntity beam, BlockPos pos, int amt) {
        if (beam.m_9236_().m_46859_(pos)) {
            BlockState snow = Blocks.f_50125_.m_49966_();
            if (snow.m_60710_((LevelReader)beam.m_9236_(), pos)) {
                beam.m_9236_().m_46597_(pos, snow);
            }
        } else if (beam.m_9236_().m_6425_(pos).m_76152_().equals(Fluids.f_76193_)) {
            beam.m_9236_().m_46597_(pos, Blocks.f_50449_.m_49966_());
            beam.m_9236_().m_186460_(pos, Blocks.f_50449_, Mth.m_216271_((RandomSource)beam.m_9236_().m_213780_(), (int)60, (int)120));
        }
    }

    @Override
    public boolean shouldTickBlocks() {
        return true;
    }

    @Override
    public boolean shouldTickEntities() {
        return true;
    }
}

