/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.beams.common.items;

import io.github.davidqf555.minecraft.beams.common.ServerConfigs;
import io.github.davidqf555.minecraft.beams.common.entities.BeamEntity;
import io.github.davidqf555.minecraft.beams.common.items.ProjectorInventory;
import io.github.davidqf555.minecraft.beams.registration.EntityRegistry;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class PortableProjectorItem
extends ProjectileWeaponItem {
    private static final Component INSTRUCTIONS = Component.m_237115_((String)"item.beams.portable_projector.instructions").m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.DARK_PURPLE);

    public PortableProjectorItem(Item.Properties properties) {
        super(properties);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> text, TooltipFlag flag) {
        text.add(INSTRUCTIONS);
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity entity, int duration) {
        Object beam;
        int time = this.m_8105_(stack) - duration;
        double range = this.getRange(time);
        if (range > 0.0 && (beam = BeamEntity.shoot((EntityType)EntityRegistry.BEAM.get(), world, entity.m_20299_(1.0f), entity.m_20154_(), range, ProjectorInventory.getModuleTypes((Container)ProjectorInventory.get(stack)), 0.5, 0.5, null, null)) != null) {
            ((BeamEntity)((Object)beam)).setLifespan(20);
            ((BeamEntity)((Object)beam)).setShooter(entity.m_20148_());
        }
    }

    protected double getRange(int time) {
        return time < 20 ? 0.0 : (double)this.m_6615_() * Math.min(1.0, (double)time / 200.0);
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6144_()) {
            if (world.m_5776_()) {
                return InteractionResultHolder.m_19090_((Object)stack);
            }
            player.m_5893_((MenuProvider)ProjectorInventory.get(stack));
        } else {
            player.m_6672_(hand);
        }
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    public Predicate<ItemStack> m_6437_() {
        return stack -> false;
    }

    public int m_6615_() {
        return (Integer)ServerConfigs.INSTANCE.portableProjectorMaxRange.get();
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new ProjectorInventory.Provider();
    }
}

