/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.beams.common.items;

import io.github.davidqf555.minecraft.beams.common.ServerConfigs;
import io.github.davidqf555.minecraft.beams.common.blocks.IPointable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class PointerItem
extends Item {
    private static final Component CONNECTED = Component.m_237115_((String)Util.m_137492_((String)"message", (ResourceLocation)new ResourceLocation("beams", "pointer_connected"))).m_130940_(ChatFormatting.GREEN);
    private static final Component DISCONNECTED = Component.m_237115_((String)Util.m_137492_((String)"message", (ResourceLocation)new ResourceLocation("beams", "pointer_disconnected"))).m_130940_(ChatFormatting.RED);
    private static final String POSITION = Util.m_137492_((String)"text", (ResourceLocation)new ResourceLocation("beams", "position"));

    public PointerItem(Item.Properties properties) {
        super(properties);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> text, TooltipFlag flag) {
        this.getConnected(stack).values().stream().map(pos -> Component.m_237110_((String)POSITION, (Object[])new Object[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}).m_130940_(ChatFormatting.GREEN)).forEach(text::add);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos pos;
        Level world;
        Block block;
        Player player = context.m_43723_();
        if (player != null && player.m_6144_() && (block = (world = context.m_43725_()).m_8055_(pos = context.m_8083_()).m_60734_()) instanceof IPointable) {
            UUID id = ((IPointable)block).getConnectionID(world, pos);
            if (id != null) {
                ItemStack stack = context.m_43722_();
                Map<UUID, BlockPos> connections = this.getConnected(stack);
                if (connections.containsKey(id)) {
                    connections.remove(id);
                    if (world.m_5776_()) {
                        player.m_213846_(DISCONNECTED);
                    }
                } else {
                    connections.put(id, pos);
                    if (world.m_5776_()) {
                        player.m_213846_(CONNECTED);
                    }
                }
                this.setConnected(stack, connections);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6225_(context);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack;
        Map<UUID, BlockPos> connections;
        if (!player.m_6144_() && !(connections = this.getConnected(stack = player.m_21120_(hand))).isEmpty()) {
            Vec3 start = player.m_20299_(1.0f);
            double range = (Double)ServerConfigs.INSTANCE.pointerRange.get();
            Vec3 end = start.m_82549_(player.m_20154_().m_82490_(range));
            EntityHitResult entity = ProjectileUtil.m_37304_((Level)world, (Entity)player, (Vec3)start, (Vec3)end, (AABB)AABB.m_165882_((Vec3)start, (double)(range * 2.0), (double)(range * 2.0), (double)(range * 2.0)), check -> true);
            Vec3 target = entity == null ? world.m_45547_(new ClipContext(start, end, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, null)).m_82450_() : entity.m_82443_().m_20299_(1.0f);
            for (UUID key : new ArrayList<UUID>(connections.keySet())) {
                BlockPos pos = connections.get(key);
                Block block = world.m_8055_(pos).m_60734_();
                if (block instanceof IPointable && key.equals(((IPointable)block).getConnectionID(world, pos))) {
                    ((IPointable)block).onPoint(world, pos, target);
                    continue;
                }
                connections.remove(key);
            }
            this.setConnected(stack, connections);
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)world.m_5776_());
        }
        return super.m_7203_(world, player, hand);
    }

    public Map<UUID, BlockPos> getConnected(ItemStack stack) {
        HashMap<UUID, BlockPos> connections = new HashMap<UUID, BlockPos>();
        CompoundTag tag = stack.m_41698_("beams");
        if (tag.m_128425_("Connections", 10)) {
            CompoundTag map = tag.m_128469_("Connections");
            for (String key : map.m_128431_()) {
                int[] arr;
                UUID id;
                try {
                    id = UUID.fromString(key);
                }
                catch (IllegalArgumentException exception) {
                    continue;
                }
                if (!map.m_128425_(key, 11) || (arr = map.m_128465_(key)).length < 3) continue;
                connections.put(id, new BlockPos(arr[0], arr[1], arr[2]));
            }
        }
        return connections;
    }

    public void setConnected(ItemStack stack, Map<UUID, BlockPos> connections) {
        CompoundTag tag = new CompoundTag();
        connections.forEach((id, pos) -> tag.m_128365_(id.toString(), (Tag)new IntArrayTag(new int[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()})));
        stack.m_41698_("beams").m_128365_("Connections", (Tag)tag);
    }
}

