/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.beams.common.items;

import io.github.davidqf555.minecraft.beams.common.items.TargetingModuleItem;
import io.github.davidqf555.minecraft.beams.common.modules.targeting.EntityTargetingType;
import io.github.davidqf555.minecraft.beams.common.modules.targeting.TargetingModuleType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class PlayerTargetingModuleItem
extends TargetingModuleItem {
    private static final Component BLACKLIST = Component.m_237115_((String)"item.beams.player_targeting_module.blacklist").m_130940_(ChatFormatting.GREEN);
    private static final Component WHITELIST = Component.m_237115_((String)"item.beams.player_targeting_module.whitelist").m_130940_(ChatFormatting.RED);
    private static final Component INSTRUCTIONS = Component.m_237115_((String)"item.beams.player_targeting_module.instructions").m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.DARK_PURPLE);
    private static final String PLAYER_NAME = "item.beams.player_targeting_module.player_name";

    public PlayerTargetingModuleItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public TargetingModuleType getType(ItemStack stack) {
        Predicate<Entity> condition = entity -> entity instanceof Player;
        Set<UUID> targets = this.getMarkedPlayers(stack).keySet();
        condition = this.isWhitelist(stack) ? condition.and(entity -> targets.contains(entity.m_20148_())) : condition.and(entity -> !targets.contains(entity.m_20148_()));
        return new EntityTargetingType(condition);
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity entity, InteractionHand hand) {
        if (!entity.m_9236_().m_5776_() && entity instanceof Player && !this.getMarkedPlayers(stack).containsKey(entity.m_20148_())) {
            if (player.m_6144_()) {
                this.removeMarkedPlayer(stack, entity.m_20148_());
            } else {
                this.addMarkedPlayer(stack, (Player)entity);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!world.m_5776_()) {
            this.setWhitelist(stack, !this.isWhitelist(stack));
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> text, TooltipFlag flag) {
        text.add(this.isWhitelist(stack) ? WHITELIST : BLACKLIST);
        for (Component name : this.getMarkedPlayers(stack).values()) {
            text.add((Component)Component.m_237110_((String)PLAYER_NAME, (Object[])new Object[]{name}).m_130940_(ChatFormatting.BLUE));
        }
        text.add(INSTRUCTIONS);
    }

    public Map<UUID, Component> getMarkedPlayers(ItemStack stack) {
        HashMap<UUID, Component> players = new HashMap<UUID, Component>();
        CompoundTag tag = stack.m_41698_("beams");
        if (tag.m_128425_("Players", 9)) {
            for (Tag nbt : tag.m_128437_("Players", 10)) {
                if (!((CompoundTag)nbt).m_128425_("UUID", 11) || !((CompoundTag)nbt).m_128425_("Name", 8)) continue;
                players.put(((CompoundTag)nbt).m_128342_("UUID"), (Component)Component.Serializer.m_130701_((String)((CompoundTag)nbt).m_128461_("Name")));
            }
        }
        return players;
    }

    public void addMarkedPlayer(ItemStack stack, Player player) {
        ListTag list;
        CompoundTag tag = stack.m_41698_("beams");
        if (tag.m_128425_("Players", 9)) {
            list = tag.m_128437_("Players", 10);
        } else {
            list = new ListTag();
            tag.m_128365_("Players", (Tag)list);
        }
        CompoundTag val = new CompoundTag();
        val.m_128362_("UUID", player.m_20148_());
        val.m_128359_("Name", Component.Serializer.m_130703_((Component)player.m_5446_()));
        list.add((Object)val);
    }

    public void removeMarkedPlayer(ItemStack stack, UUID player) {
        CompoundTag tag = stack.m_41698_("beams");
        if (tag.m_128425_("Players", 9)) {
            ListTag list = tag.m_128437_("Players", 10);
            list.removeIf(nbt -> ((CompoundTag)nbt).m_128425_("UUID", 11) && ((CompoundTag)nbt).m_128342_("UUID").equals(player));
        }
    }

    public void setWhitelist(ItemStack stack, boolean whitelist) {
        stack.m_41698_("beams").m_128379_("Whitelist", whitelist);
    }

    public boolean isWhitelist(ItemStack stack) {
        CompoundTag tag = stack.m_41698_("beams");
        if (tag.m_128425_("Whitelist", 1)) {
            return tag.m_128471_("Whitelist");
        }
        return false;
    }
}

