/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.beams.common.blocks.te;

import io.github.davidqf555.minecraft.beams.common.ServerConfigs;
import io.github.davidqf555.minecraft.beams.common.blocks.BeamTurretBlock;
import io.github.davidqf555.minecraft.beams.common.blocks.te.OmnidirectionalProjectorTileEntity;
import io.github.davidqf555.minecraft.beams.common.items.TargetingModuleItem;
import io.github.davidqf555.minecraft.beams.common.items.TurretContainer;
import io.github.davidqf555.minecraft.beams.registration.TileEntityRegistry;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class TurretTileEntity
extends OmnidirectionalProjectorTileEntity {
    private static final double START_DIST = 0.2;
    private static final double STOP_DIST = 0.5;
    private static final float ANGULAR_SPEED = 0.15707964f;
    protected final NonNullList<ItemStack> targeting = NonNullList.m_122780_((int)3, (Object)ItemStack.f_41583_);

    protected TurretTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public TurretTileEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)TileEntityRegistry.TURRET.get(), pos, state);
    }

    @Override
    public void tick() {
        BlockState state;
        if (this.m_58898_() && ((Boolean)(state = this.m_58900_()).m_61143_((Property)BeamTurretBlock.TRIGGERED)).booleanValue()) {
            boolean on = (Boolean)state.m_61143_((Property)BeamTurretBlock.IN_RANGE);
            boolean hasTarget = false;
            for (ItemStack stack : this.targeting) {
                Vec3 target;
                Item item = stack.m_41720_();
                if (stack.m_41619_() || !(item instanceof TargetingModuleItem) || (target = ((TargetingModuleItem)item).getType(stack).tick(this, (Double)ServerConfigs.INSTANCE.projectorMaxRange.get())) == null) continue;
                hasTarget = true;
                BlockPos pos = this.m_58899_();
                if (on) {
                    if (!this.shouldStop(target)) break;
                    this.m_58904_().m_46597_(pos, (BlockState)state.m_61124_((Property)BeamTurretBlock.IN_RANGE, (Comparable)Boolean.valueOf(false)));
                    this.markChanged();
                    break;
                }
                if (this.shouldStart(target)) {
                    this.m_58904_().m_46597_(pos, (BlockState)state.m_61124_((Property)BeamTurretBlock.IN_RANGE, (Comparable)Boolean.valueOf(true)));
                    this.markChanged();
                    break;
                }
                this.rotateTowards(target.m_82546_(Vec3.m_82512_((Vec3i)pos)).m_82541_());
                break;
            }
            if (!hasTarget && on) {
                this.m_58904_().m_46597_(this.m_58899_(), (BlockState)state.m_61124_((Property)BeamTurretBlock.IN_RANGE, (Comparable)Boolean.valueOf(false)));
                this.markChanged();
            }
        }
        super.tick();
    }

    private void rotateTowards(Vec3 direction) {
        Vec3 current = this.getDirection();
        Vec3 comp = current.m_82537_(direction).m_82537_(current);
        this.setDirection(current.m_82490_((double)Mth.m_14089_((float)0.15707964f)).m_82549_(comp.m_82490_((double)Mth.m_14031_((float)0.15707964f))));
    }

    protected boolean shouldStart(Vec3 target) {
        return this.getBeamDistanceSqr(target) <= 0.04000000000000001;
    }

    protected boolean shouldStop(Vec3 target) {
        return this.getBeamDistanceSqr(target) >= 0.25;
    }

    private double getBeamDistanceSqr(Vec3 target) {
        Vec3 expected;
        Vec3 current = this.getDirection();
        double dot = current.m_82526_(expected = target.m_82546_(Vec3.m_82512_((Vec3i)this.m_58899_())));
        return dot <= 0.0 ? Double.POSITIVE_INFINITY : current.m_82490_(expected.m_82556_() / dot).m_82546_(expected).m_82556_();
    }

    @Override
    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new TurretContainer(id, inventory, this);
    }

    @Override
    public int m_6643_() {
        return super.m_6643_() + this.targeting.size();
    }

    @Override
    public boolean m_7983_() {
        return super.m_7983_() && this.targeting.stream().allMatch(ItemStack::m_41619_);
    }

    @Override
    public ItemStack m_8020_(int index) {
        int dif = super.m_6643_();
        return index >= dif && index < this.m_6643_() ? (ItemStack)this.targeting.get(index - dif) : super.m_8020_(index);
    }

    @Override
    public ItemStack m_7407_(int index, int amount) {
        int dif = super.m_6643_();
        if (index < dif) {
            return super.m_7407_(index, amount);
        }
        ItemStack stack = ContainerHelper.m_18969_(this.targeting, (int)(index - dif), (int)amount);
        if (!stack.m_41619_()) {
            this.m_6596_();
        }
        return stack;
    }

    @Override
    public ItemStack m_8016_(int index) {
        int dif = super.m_6643_();
        if (index < dif) {
            return super.m_8016_(index);
        }
        return ContainerHelper.m_18966_(this.targeting, (int)(index - dif));
    }

    @Override
    public void setItemNoUpdate(int index, ItemStack stack) {
        int dif = super.m_6643_();
        if (index < dif) {
            super.setItemNoUpdate(index, stack);
        } else {
            this.targeting.set(index - dif, (Object)stack);
            if (stack.m_41613_() > this.m_6893_()) {
                stack.m_41764_(this.m_6893_());
            }
        }
    }

    @Override
    public void m_6836_(int index, ItemStack stack) {
        int dif = super.m_6643_();
        if (index < dif) {
            super.m_6836_(index, stack);
        } else {
            this.setItemNoUpdate(index, stack);
            this.m_6596_();
        }
    }

    @Override
    public void m_6211_() {
        super.m_6211_();
        this.targeting.clear();
    }
}

