/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.beams.common.blocks.te;

import io.github.davidqf555.minecraft.beams.common.blocks.AbstractProjectorBlock;
import io.github.davidqf555.minecraft.beams.common.entities.BeamEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class AbstractProjectorTileEntity
extends BlockEntity {
    private final List<UUID> beams = new ArrayList<UUID>();
    private boolean changed;

    public AbstractProjectorTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public static <T extends AbstractProjectorTileEntity> void tick(Level level, BlockPos pos, BlockState state, T te) {
        te.tick();
    }

    protected void updateBeams() {
        BlockState state = this.m_58900_();
        Block block = state.m_60734_();
        if (this.m_58898_() && block instanceof AbstractProjectorBlock) {
            this.clearBeams();
            if (((AbstractProjectorBlock)block).isActive(state)) {
                for (BeamEntity beam : ((AbstractProjectorBlock)block).shoot(this.m_58904_(), this.m_58899_(), state)) {
                    this.addBeam(beam.m_20148_());
                }
            }
        }
    }

    public void clearBeams() {
        for (UUID id : new ArrayList<UUID>(this.getBeams())) {
            this.removeBeam(id);
        }
    }

    public void tick() {
        if (this.changed) {
            this.updateBeams();
            this.changed = false;
        }
    }

    public void markChanged() {
        this.changed = true;
    }

    public List<UUID> getBeams() {
        return this.beams;
    }

    public void addBeam(UUID beam) {
        this.getBeams().add(beam);
    }

    public void removeBeam(UUID beam) {
        Entity entity;
        Level world = this.m_58904_();
        if (world instanceof ServerLevel && (entity = ((ServerLevel)world).m_8791_(beam)) != null) {
            entity.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        this.getBeams().remove(beam);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ListTag beams = new ListTag();
        for (UUID beam : this.getBeams()) {
            beams.add((Object)NbtUtils.m_129226_((UUID)beam));
        }
        tag.m_128365_("Beams", (Tag)beams);
        tag.m_128379_("Changed", this.changed);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128425_("Beams", 9)) {
            for (Tag nbt : tag.m_128437_("Beams", 11)) {
                this.addBeam(NbtUtils.m_129233_((Tag)nbt));
            }
        }
        if (tag.m_128425_("Changed", 1)) {
            this.changed = tag.m_128471_("Changed");
        }
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }
}

