/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.beams.common.blocks;

import io.github.davidqf555.minecraft.beams.common.blocks.AbstractProjectorBlock;
import io.github.davidqf555.minecraft.beams.common.blocks.IBeamCollisionEffect;
import io.github.davidqf555.minecraft.beams.common.blocks.te.RedirectorTileEntity;
import io.github.davidqf555.minecraft.beams.common.entities.BeamEntity;
import io.github.davidqf555.minecraft.beams.common.modules.ProjectorModuleType;
import io.github.davidqf555.minecraft.beams.registration.EntityRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractRedirectorBlock
extends AbstractProjectorBlock
implements IBeamCollisionEffect {
    protected AbstractRedirectorBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public boolean isActive(BlockState state) {
        return true;
    }

    @Override
    public List<BeamEntity> shoot(Level world, BlockPos pos, BlockState state) {
        ArrayList<BeamEntity> beams = new ArrayList<BeamEntity>();
        for (BeamEntity beam : this.getHit(world, pos)) {
            Vec3 start = beam.m_20182_();
            Vec3 end = beam.getEnd();
            Vec3 original = end.m_82546_(start);
            double length = original.m_82553_();
            original = original.m_82490_(1.0 / length);
            List<Vec3> directions = this.getRedirectedDirection(world, pos, state, original);
            for (Vec3 dir : directions) {
                double width = beam.getEndWidth() * this.getRedirectWidthFactor();
                double height = beam.getEndHeight() * this.getRedirectHeightFactor();
                double maxLength = beam.getMaxRange() - length;
                Vec3 redirectStart = end.m_82546_(original.m_82490_(0.1)).m_82549_(this.getOffset(world, pos, dir));
                Object redirect = BeamEntity.shoot((EntityType)EntityRegistry.BEAM.get(), world, redirectStart, dir, maxLength, this.getRedirectedModules(dir, beam.getModules()), width, height, beam.m_20148_(), pos);
                if (redirect == null) continue;
                beams.add((BeamEntity)((Object)redirect));
            }
        }
        return beams;
    }

    protected List<BeamEntity> getHit(Level world, BlockPos pos) {
        BlockEntity te;
        ArrayList<BeamEntity> beams = new ArrayList<BeamEntity>();
        if (world instanceof ServerLevel && (te = world.m_7702_(pos)) instanceof RedirectorTileEntity) {
            for (UUID id : new ArrayList<UUID>(((RedirectorTileEntity)te).getHit())) {
                Entity entity = ((ServerLevel)world).m_8791_(id);
                if (entity instanceof BeamEntity && entity.m_6084_()) {
                    beams.add((BeamEntity)entity);
                    continue;
                }
                ((RedirectorTileEntity)te).removeHit(id);
            }
        }
        return beams;
    }

    protected abstract List<Vec3> getRedirectedDirection(Level var1, BlockPos var2, BlockState var3, Vec3 var4);

    protected abstract Vec3 getOffset(Level var1, BlockPos var2, Vec3 var3);

    protected Map<ProjectorModuleType, Integer> getRedirectedModules(Vec3 dir, Map<ProjectorModuleType, Integer> modules) {
        return modules;
    }

    @Override
    public void onBeamStartCollision(BeamEntity beam, BlockPos pos, BlockState state) {
        BlockEntity te = beam.m_9236_().m_7702_(pos);
        if (te instanceof RedirectorTileEntity && !((RedirectorTileEntity)te).getBeams().contains(beam.m_20148_()) && beam.getParents().stream().noneMatch(parent -> ((RedirectorTileEntity)te).getHit().contains(parent)) && ((RedirectorTileEntity)te).addHit(beam.m_20148_())) {
            this.updateBeams(beam.m_9236_(), pos);
        }
    }

    @Override
    public void onBeamStopCollision(BeamEntity beam, BlockPos pos, BlockState state) {
        BlockEntity te = beam.m_9236_().m_7702_(pos);
        if (te instanceof RedirectorTileEntity && ((RedirectorTileEntity)te).removeHit(beam.m_20148_())) {
            this.updateBeams(beam.m_9236_(), pos);
        }
    }

    @Override
    public RedirectorTileEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new RedirectorTileEntity(pos, state);
    }

    protected double getRedirectWidthFactor() {
        return 1.0;
    }

    protected double getRedirectHeightFactor() {
        return 1.0;
    }
}

