/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.beams.common;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ServerConfigs {
    public static final ServerConfigs INSTANCE;
    public static final ForgeConfigSpec SPEC;
    public final ForgeConfigSpec.DoubleValue projectorMaxRange;
    public final ForgeConfigSpec.DoubleValue defaultBeamSize;
    public final ForgeConfigSpec.DoubleValue pointerRange;
    public final ForgeConfigSpec.IntValue portableProjectorMaxRange;

    public ServerConfigs(ForgeConfigSpec.Builder builder) {
        builder.push("Server config for Beams mod");
        this.defaultBeamSize = builder.comment("This is the the default width/height in blocks of beams projected from projectors. ").defineInRange("beamSize", 0.5, 0.0, Double.MAX_VALUE);
        this.projectorMaxRange = builder.comment("This is the max range in blocks that a projector projects beams. ").defineInRange("projectorRange", 64.0, 0.0, Double.MAX_VALUE);
        this.portableProjectorMaxRange = builder.comment("This is the max range in blocks that a portable projector projects beams. ").defineInRange("portableProjectorRange", 64, 0, Integer.MAX_VALUE);
        this.pointerRange = builder.comment("This is the range in blocks of the projector pointer").defineInRange("pointerRange", 64.0, 0.0, Double.MAX_VALUE);
        builder.pop();
    }

    static {
        Pair pair = new ForgeConfigSpec.Builder().configure(ServerConfigs::new);
        INSTANCE = (ServerConfigs)pair.getLeft();
        SPEC = (ForgeConfigSpec)pair.getRight();
    }
}

