/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.item.inv.InteractType;
import com.hollingsworth.arsnouveau.api.item.inv.InventoryManager;
import com.hollingsworth.arsnouveau.api.item.inv.SlotReference;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.TileCaster;
import com.hollingsworth.arsnouveau.api.util.IWololoable;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.crafting.recipes.IDyeable;
import com.hollingsworth.arsnouveau.common.entity.debug.FixedStack;
import com.hollingsworth.arsnouveau.common.mixin.MobAccessor;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentRandomize;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSensitive;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;

public class EffectWololo
extends AbstractEffect {
    public static EffectWololo INSTANCE = new EffectWololo();
    public static int MAX_RECIPE_CACHE = 16;
    public static FixedStack<CraftingRecipe> recipeCache = new FixedStack(MAX_RECIPE_CACHE);
    public static Map<ParticleColor, Item> vanillaColors = new HashMap<ParticleColor, Item>();

    public EffectWololo() {
        super("wololo", "Wololo");
    }

    @Override
    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        Entity entity = rayTraceResult.m_82443_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        ANFakePlayer player = ANFakePlayer.getPlayer((ServerLevel)world);
        ItemStack dyeStack = this.getDye(shooter, spellStats, spellContext, (Player)player);
        if (dyeStack.m_41619_()) {
            return;
        }
        DyeItem dye = (DyeItem)dyeStack.m_41720_();
        if (living instanceof Sheep) {
            Sheep sheep = (Sheep)living;
            sheep.m_29855_(dye.m_41089_());
        } else if (spellStats.isSensitive() || living instanceof ArmorStand) {
            for (ItemStack armorStack : living.m_6168_()) {
                if (armorStack.m_41619_()) continue;
                if (armorStack.m_41720_() instanceof DyeableLeatherItem) {
                    ItemStack temp = DyeableLeatherItem.m_41118_((ItemStack)armorStack, List.of(dye));
                    armorStack.m_41751_(temp.m_41783_());
                    continue;
                }
                Item item = armorStack.m_41720_();
                if (!(item instanceof IDyeable)) continue;
                IDyeable iDyeable = (IDyeable)item;
                iDyeable.onDye(armorStack, dye.m_41089_());
            }
        } else if (living instanceof Mob) {
            Mob mob = (Mob)living;
            player.m_21008_(InteractionHand.MAIN_HAND, dyeStack);
            ((MobAccessor)mob).callMobInteract((Player)player, InteractionHand.MAIN_HAND);
            player.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        }
        world.m_6263_(null, living.m_20185_(), living.m_20186_(), living.m_20189_(), SoundEvents.f_11869_, SoundSource.PLAYERS, spellContext.getSpell().sound.volume, spellContext.getSpell().sound.pitch);
    }

    @NotNull
    private ItemStack getDye(@NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, Player player) {
        ItemStack stack;
        if (spellContext.getCaster() instanceof TileCaster) {
            InventoryManager manager = spellContext.getCaster().getInvManager();
            SlotReference reference = manager.findItem(i -> i.m_41720_() instanceof DyeItem, InteractType.EXTRACT);
            if (!reference.isEmpty()) {
                return reference.getHandler().getStackInSlot(reference.getSlot());
            }
        } else if (this.isRealPlayer((Entity)shooter) && (stack = player.m_21206_()).m_41720_() instanceof DyeItem) {
            return stack;
        }
        DyeItem dye = spellStats.isRandomized() ? this.getRandomDye(shooter.m_217043_()) : EffectWololo.getDyeItemFromSpell(spellContext);
        return dye.m_7968_();
    }

    @Override
    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        BlockPos blockPos = rayTraceResult.m_82425_();
        BlockEntity blockEntity = world.m_7702_(blockPos);
        if (blockEntity instanceof IWololoable) {
            IWololoable tileToDye = (IWololoable)blockEntity;
            ParticleColor color = spellStats.isRandomized() ? ParticleColor.makeRandomColor(255, 255, 255, shooter.m_217043_()) : spellContext.getSpell().color;
            tileToDye.setColor(color);
        } else {
            ItemStack dyeStack = this.getDye(shooter, spellStats, spellContext, (Player)ANFakePlayer.getPlayer((ServerLevel)world));
            if (dyeStack.m_41619_()) {
                return;
            }
            DyeItem dye = (DyeItem)dyeStack.m_41720_();
            if (blockEntity instanceof SignBlockEntity) {
                SignBlockEntity sign = (SignBlockEntity)blockEntity;
                Player player = this.getPlayer(shooter, (ServerLevel)world);
                dye.m_276787_(world, sign, sign.m_277202_(player), player);
            } else {
                Block hitBlock = world.m_8055_(blockPos).m_60734_();
                if (hitBlock == Blocks.f_50016_) {
                    return;
                }
                ItemStack result = this.getDyedResult((ServerLevel)world, EffectWololo.makeContainer(dye, hitBlock));
                if (!(!result.m_41619_() && result.m_41720_() instanceof BlockItem || !(result = this.getDyedResult((ServerLevel)world, EffectWololo.makeContainer8(dye, hitBlock))).m_41619_() && result.m_41720_() instanceof BlockItem)) {
                    return;
                }
                BlockItem blockItem = (BlockItem)result.m_41720_();
                world.m_46597_(blockPos, blockItem.m_40614_().m_49966_());
            }
        }
    }

    @NotNull
    private ItemStack getDyedResult(ServerLevel world, CraftingContainer craftingcontainer) {
        Optional<CraftingRecipe> recipe = recipeCache.stream().filter(craftingRecipe -> craftingRecipe.m_5818_((Container)craftingcontainer, (Level)world)).findFirst();
        if (recipe.isPresent()) {
            recipeCache.add(recipe.get());
            return recipe.get().m_5874_((Container)craftingcontainer, world.m_9598_());
        }
        return world.m_7465_().m_44015_(RecipeType.f_44107_, (Container)craftingcontainer, (Level)world).map(craftingRecipe -> craftingRecipe.m_5874_((Container)craftingcontainer, world.m_9598_())).orElse(ItemStack.f_41583_);
    }

    private static CraftingContainer makeContainer(DyeItem targetColor, Block blockToDye) {
        TransientCraftingContainer craftingcontainer = new TransientCraftingContainer(new AbstractContainerMenu(null, -1){

            public ItemStack m_7648_(Player p_218264_, int p_218265_) {
                return ItemStack.f_41583_;
            }

            public boolean m_6875_(Player p_29888_) {
                return false;
            }
        }, 2, 1);
        craftingcontainer.m_6836_(0, new ItemStack((ItemLike)targetColor));
        craftingcontainer.m_6836_(1, new ItemStack((ItemLike)blockToDye));
        return craftingcontainer;
    }

    private static CraftingContainer makeContainer8(DyeItem targetColor, Block blockToDye) {
        TransientCraftingContainer craftingcontainer = new TransientCraftingContainer(new AbstractContainerMenu(null, -1){

            public ItemStack m_7648_(Player p_218264_, int p_218265_) {
                return ItemStack.f_41583_;
            }

            public boolean m_6875_(Player p_29888_) {
                return false;
            }
        }, 3, 3);
        for (int i = 0; i < 9; ++i) {
            craftingcontainer.m_6836_(i, i == 4 ? new ItemStack((ItemLike)targetColor) : new ItemStack((ItemLike)blockToDye));
        }
        return craftingcontainer;
    }

    private DyeItem getRandomDye(RandomSource random) {
        return (DyeItem)vanillaColors.values().toArray()[random.m_188503_(vanillaColors.size())];
    }

    private static DyeItem getDyeItemFromSpell(SpellContext spellContext) {
        ParticleColor spellColor = spellContext.getSpell().color;
        ParticleColor targetColor = vanillaColors.keySet().stream().min(Comparator.comparingDouble(d -> d.euclideanDistance(spellColor))).orElse(ParticleColor.WHITE);
        return (DyeItem)vanillaColors.get(targetColor);
    }

    @Override
    protected int getDefaultManaCost() {
        return 30;
    }

    @Override
    @NotNull
    protected Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(AugmentRandomize.INSTANCE, AugmentSensitive.INSTANCE);
    }

    @Override
    public String getBookDescription() {
        return "Changes the color of an entity or compatible block to the color of the spell.";
    }

    static {
        vanillaColors.put(ParticleColor.WHITE, Items.f_42535_);
        vanillaColors.put(ParticleColor.RED, Items.f_42497_);
        vanillaColors.put(ParticleColor.GREEN, Items.f_42496_);
        vanillaColors.put(ParticleColor.BLUE, Items.f_42494_);
        vanillaColors.put(ParticleColor.YELLOW, Items.f_42539_);
        vanillaColors.put(ParticleColor.PURPLE, Items.f_42493_);
        vanillaColors.put(ParticleColor.CYAN, Items.f_42492_);
        vanillaColors.put(ParticleColor.ORANGE, Items.f_42536_);
        vanillaColors.put(ParticleColor.MAGENTA, Items.f_42537_);
        vanillaColors.put(ParticleColor.LIGHT_BLUE, Items.f_42538_);
        vanillaColors.put(ParticleColor.LIME, Items.f_42540_);
        vanillaColors.put(ParticleColor.PINK, Items.f_42489_);
        vanillaColors.put(ParticleColor.GRAY, Items.f_42490_);
        vanillaColors.put(ParticleColor.LIGHT_GRAY, Items.f_42491_);
        vanillaColors.put(ParticleColor.BROWN, Items.f_42495_);
        vanillaColors.put(ParticleColor.BLACK, Items.f_42498_);
    }
}

