/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.statemachine.starbuncle;

import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.debug.DebugEvent;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.StarbyTransportBehavior;
import com.hollingsworth.arsnouveau.common.entity.statemachine.starbuncle.StarbyState;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TravelToPosState
extends StarbyState {
    public BlockPos targetPos;
    public int ticksRunning;
    public StarbyState nextState;

    public TravelToPosState(Starbuncle starbuncle, StarbyTransportBehavior behavior, @NotNull BlockPos targetPos, StarbyState nextState) {
        super(starbuncle, behavior);
        this.targetPos = targetPos;
        this.nextState = nextState;
    }

    @Override
    public void onStart() {
        super.onStart();
        if (this.targetPos == null) {
            this.starbuncle.setBackOff(60 + this.starbuncle.f_19853_.f_46441_.m_188503_(60));
            return;
        }
        this.starbuncle.addGoalDebug(this, new DebugEvent("StartedGoal", "Started goal "));
    }

    @Override
    @Nullable
    public StarbyState tick() {
        if (this.ticksRunning % 100 == 0 && !this.isDestinationStillValid(this.targetPos)) {
            this.starbuncle.addDebugEvent(new DebugEvent("became_invalid", "Invalid position " + this.targetPos.toString()));
            return this.nextState;
        }
        Vec3 vec3 = new Vec3((double)this.targetPos.m_123341_() + 0.5, (double)this.targetPos.m_123342_() + 0.5, (double)this.targetPos.m_123343_() + 0.5);
        if (BlockUtil.distanceFrom(this.starbuncle.m_20182_().m_82520_(0.0, 0.5, 0.0), vec3) <= 2.5 && this.isDestinationStillValid(this.targetPos)) {
            return this.onDestinationReached();
        }
        return this.setPath(this.targetPos);
    }

    public StarbyState setPath(BlockPos pos) {
        this.starbuncle.getNavigation().tryMoveToBlockPos(pos, 1.3);
        this.starbuncle.addGoalDebug(this, new DebugEvent("path_set", "path set to " + this.targetPos.toString()));
        if (this.starbuncle.getNavigation().m_26570_() != null && !this.starbuncle.getNavigation().m_26570_().m_77403_()) {
            this.starbuncle.addGoalDebug(this, new DebugEvent("unreachable", this.targetPos.toString()));
            return this.nextState;
        }
        return null;
    }

    public StarbyState onDestinationReached() {
        return this.nextState;
    }

    public boolean isDestinationStillValid(BlockPos pos) {
        return true;
    }
}

