/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.statemachine.starbuncle;

import com.hollingsworth.arsnouveau.api.event.EventQueue;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.debug.DebugEvent;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.StarbyTransportBehavior;
import com.hollingsworth.arsnouveau.common.entity.statemachine.starbuncle.DecideStarbyActionState;
import com.hollingsworth.arsnouveau.common.entity.statemachine.starbuncle.StarbyState;
import com.hollingsworth.arsnouveau.common.entity.statemachine.starbuncle.TravelToPosState;
import com.hollingsworth.arsnouveau.common.event.OpenChestEvent;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;

public class TakeItemState
extends TravelToPosState {
    public TakeItemState(Starbuncle starbuncle, StarbyTransportBehavior behavior, BlockPos target) {
        super(starbuncle, behavior, target, new DecideStarbyActionState(starbuncle, behavior));
    }

    @Override
    public StarbyState onDestinationReached() {
        Starbuncle passenger;
        Entity entity;
        Level world = this.starbuncle.f_19853_;
        BlockEntity tileEntity = world.m_7702_(this.targetPos);
        if (tileEntity == null) {
            this.starbuncle.addGoalDebug(this, new DebugEvent("TakePosBroken", "Take Tile Broken"));
            return this.nextState;
        }
        IItemHandler iItemHandler = this.behavior.getItemCapFromTile(tileEntity, (Direction)this.behavior.FROM_DIRECTION_MAP.get(this.targetPos.hashCode()));
        if (iItemHandler == null) {
            this.starbuncle.addGoalDebug(this, new DebugEvent("NoItemHandler", "No item handler at " + this.targetPos.toString()));
            return this.nextState;
        }
        this.giveStarbyStack(this.starbuncle, iItemHandler);
        if (this.starbuncle.getHeldStack().m_41619_()) {
            this.starbuncle.addGoalDebug(this, new DebugEvent("TakeFromChest", "No items to take? Cancelling goal."));
            return this.nextState;
        }
        this.starbuncle.addGoalDebug(this, new DebugEvent("SetHeld", "Taking " + this.starbuncle.getHeldStack().m_41786_().getString() + " from " + this.targetPos.toString()));
        this.starbuncle.f_19853_.m_6263_(null, this.starbuncle.m_20185_(), this.starbuncle.m_20186_(), this.starbuncle.m_20189_(), SoundEvents.f_12019_, this.starbuncle.m_5720_(), 1.0f, 1.0f);
        OpenChestEvent event = new OpenChestEvent((ServerLevel)this.level, this.targetPos, 20);
        event.open();
        EventQueue.getServerInstance().addEvent(event);
        Iterator iterator = this.starbuncle.m_146897_().iterator();
        while (iterator.hasNext() && (entity = (Entity)iterator.next()) instanceof Starbuncle && (passenger = (Starbuncle)entity).getHeldStack().m_41619_()) {
            this.giveStarbyStack(passenger, iItemHandler);
            if (passenger.getHeldStack().m_41619_()) break;
            this.starbuncle.addGoalDebug(this, new DebugEvent("SetHeldPassenger", "Taking " + passenger.getHeldStack().m_41786_().getString() + " from " + this.targetPos.toString()));
        }
        return this.nextState;
    }

    public void giveStarbyStack(Starbuncle starbuncle, IItemHandler iItemHandler) {
        for (int j = 0; j < iItemHandler.getSlots() && starbuncle.getHeldStack().m_41619_(); ++j) {
            int count;
            ItemStack stack = iItemHandler.getStackInSlot(j);
            if (stack.m_41619_() || (count = this.behavior.getMaxTake(iItemHandler.getStackInSlot(j))) <= 0) continue;
            starbuncle.setHeldStack(iItemHandler.extractItem(j, Math.min(count, stack.m_41741_()), false));
        }
    }

    @Override
    public boolean isDestinationStillValid(BlockPos pos) {
        return this.behavior.isPositionValidTake(pos);
    }
}

