/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.statemachine.starbuncle;

import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.debug.DebugEvent;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.StarbyTransportBehavior;
import com.hollingsworth.arsnouveau.common.entity.statemachine.starbuncle.DecideStarbyActionState;
import com.hollingsworth.arsnouveau.common.entity.statemachine.starbuncle.StarbyState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.pathfinder.Path;
import org.jetbrains.annotations.Nullable;

public class FindItemState
extends StarbyState {
    boolean itemStuck;
    List<ItemEntity> destList = new ArrayList<ItemEntity>();
    ItemEntity dest;
    int stuckTicks;
    Starbuncle starbyWithSpace;

    public FindItemState(Starbuncle starbuncle, StarbyTransportBehavior behavior, List<ItemEntity> destList) {
        super(starbuncle, behavior);
        this.destList = destList;
        this.starbyWithSpace = this.starbuncle.getStarbuncleWithSpace();
    }

    @Override
    public void onStart() {
        super.onStart();
        if (this.destList.isEmpty()) {
            return;
        }
        ArrayList<ItemEntity> validDestinations = new ArrayList<ItemEntity>();
        for (ItemEntity entity : this.destList) {
            if (this.behavior.getValidStorePos(entity.m_32055_()) == null) continue;
            validDestinations.add(entity);
        }
        this.destList = validDestinations;
        Collections.shuffle(this.destList);
        for (ItemEntity e : this.destList) {
            Path path = this.starbuncle.minecraftPathNav.m_148218_(BlockPos.m_274446_((Position)e.m_20182_()), 1, 9);
            if (path == null || !path.m_77403_()) continue;
            this.dest = e;
            this.starbuncle.addGoalDebug(this, new DebugEvent("DestSet", "Dest set to " + e));
            break;
        }
    }

    public static List<ItemEntity> nearbyItems(Starbuncle starbuncle, StarbyTransportBehavior behavior) {
        return starbuncle.f_19853_.m_6443_(ItemEntity.class, starbuncle.getAABB(), itemEntity -> !itemEntity.m_32063_() && itemEntity.m_6084_() && behavior.getValidStorePos(itemEntity.m_32055_()) != null);
    }

    @Override
    @Nullable
    public StarbyState tick() {
        if (this.dest == null) {
            this.starbuncle.setBackOff(30 + this.starbuncle.f_19853_.f_46441_.m_188503_(30));
            this.starbuncle.addGoalDebug(this, new DebugEvent("NotReachable", "No pathable items nearby"));
            return new DecideStarbyActionState(this.starbuncle, this.behavior);
        }
        if (this.behavior.isPickupDisabled()) {
            return new DecideStarbyActionState(this.starbuncle, this.behavior);
        }
        ItemStack itemstack = this.starbyWithSpace.getHeldStack();
        if (!itemstack.m_41619_()) {
            this.starbuncle.addGoalDebug(this, new DebugEvent("ItemPickup", "Received item, ending."));
            this.starbuncle.getNavigation().m_26573_();
            Starbuncle nextAvailableStarby = this.starbuncle.getStarbuncleWithSpace();
            List<ItemEntity> nearbyItems = FindItemState.nearbyItems(this.starbuncle, this.behavior);
            if (nextAvailableStarby != null && !nearbyItems.isEmpty()) {
                System.out.println(this + " set next starby to " + nextAvailableStarby);
                return new FindItemState(this.starbuncle, this.behavior, nearbyItems);
            }
            return new DecideStarbyActionState(this.starbuncle, this.behavior);
        }
        if (this.ticksRunning > 300) {
            this.starbuncle.addGoalDebug(this, new DebugEvent("TooLong", "Stopped finding item, time finding expired"));
            return new DecideStarbyActionState(this.starbuncle, this.behavior);
        }
        if (this.itemStuck || this.starbyWithSpace == null) {
            return new DecideStarbyActionState(this.starbuncle, this.behavior);
        }
        if (this.dest == null || this.dest.m_32055_().m_41619_() || this.dest.m_213877_()) {
            this.itemStuck = true;
            this.starbuncle.addGoalDebug(this, new DebugEvent("ItemRemoved", "Item removed during goal"));
            return new DecideStarbyActionState(this.starbuncle, this.behavior);
        }
        this.starbuncle.minecraftPathNav.m_26573_();
        Path path = this.starbuncle.minecraftPathNav.m_148218_(BlockPos.m_274446_((Position)this.dest.m_20182_()), 1, 9);
        if (path == null || !path.m_77403_()) {
            ++this.stuckTicks;
            if (this.stuckTicks > 100) {
                this.itemStuck = true;
                this.starbuncle.addGoalDebug(this, new DebugEvent("ItemStuck", "Item stuck for 5 seconds. Ending goal"));
            }
            return super.tick();
        }
        this.starbuncle.getNavigation().m_5624_((Entity)this.dest, 1.4);
        this.starbuncle.addGoalDebug(this, new DebugEvent("PathTo", "Pathing to " + this.dest));
        return super.tick();
    }
}

