/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.events.behaviors;

import net.mehvahdjukaar.amendments.common.ExtendedHangingSign;
import net.mehvahdjukaar.amendments.common.tile.HangingSignTileExtension;
import net.mehvahdjukaar.amendments.configs.CommonConfigs;
import net.mehvahdjukaar.amendments.events.behaviors.BlockUse;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SignApplicator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;

public class HangingSignDisplayItem
implements BlockUse {
    public static final HangingSignDisplayItem INSTANCE = new HangingSignDisplayItem();

    @Override
    public boolean isEnabled() {
        return CommonConfigs.HANGING_SIGN_ITEM.get();
    }

    @Override
    public boolean appliesToBlock(Block block) {
        return block instanceof CeilingHangingSignBlock || block instanceof WallHangingSignBlock;
    }

    @Override
    public InteractionResult tryPerformingAction(BlockState state, BlockPos pos, Level level, Player player, InteractionHand hand, ItemStack stack, BlockHitResult hit) {
        if (!this.isEnabled()) {
            return InteractionResult.PASS;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ExtendedHangingSign) {
            ExtendedHangingSign e = (ExtendedHangingSign)blockEntity;
            SignBlockEntity be = (SignBlockEntity)e;
            HangingSignTileExtension ext = e.getExtension();
            if (!be.m_277118_()) {
                ItemStack item;
                boolean front = be.m_277202_(player);
                ItemStack itemStack = item = front ? ext.getFrontItem() : ext.getBackItem();
                if (!stack.m_41619_() && !item.m_41619_()) {
                    return InteractionResult.FAIL;
                }
                if (stack.m_41720_() instanceof SignApplicator && !player.m_36341_()) {
                    return InteractionResult.PASS;
                }
                return HangingSignDisplayItem.interactWithFace(state, pos, level, player, hand, stack, be, ext, front);
            }
        }
        return InteractionResult.PASS;
    }

    private static InteractionResult interactWithFace(BlockState state, BlockPos pos, Level level, Player player, InteractionHand hand, ItemStack stack, SignBlockEntity be, HangingSignTileExtension ext, boolean front) {
        boolean hasItem;
        ItemStack tileItem = front ? ext.getFrontItem() : ext.getBackItem();
        boolean bl = hasItem = !tileItem.m_41619_();
        if (!hasItem && !stack.m_41619_()) {
            level.m_5594_(player, pos, SoundEvents.f_12013_, SoundSource.BLOCKS, 1.0f, level.f_46441_.m_188501_() * 0.1f + 0.95f);
            if (level.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            if (front) {
                ext.setFrontItem(stack.m_255036_(1));
            } else {
                ext.setBackItem(stack.m_255036_(1));
            }
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            HangingSignDisplayItem.setMessagesAndUpdate(be, front, "item");
            level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223719_((Entity)player, (BlockState)state));
            player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
            return InteractionResult.CONSUME;
        }
        if (hasItem && stack.m_41619_()) {
            if (level.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            player.m_21008_(hand, tileItem.m_41620_(1));
            HangingSignDisplayItem.setMessagesAndUpdate(be, front, "");
            level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223719_((Entity)player, (BlockState)state));
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    private static void setMessagesAndUpdate(SignBlockEntity sign, boolean front, String s) {
        sign.m_277073_(signText -> {
            MutableComponent literal = Component.m_237113_((String)s);
            return signText.m_276913_(0, (Component)literal).m_276913_(1, (Component)literal).m_276913_(2, (Component)literal).m_276913_(3, (Component)literal);
        }, front);
    }
}

