/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.block;

import java.util.Map;
import net.mehvahdjukaar.amendments.common.tile.LiquidCauldronBlockTile;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class ModCauldronBlock
extends AbstractCauldronBlock
implements EntityBlock {
    public ModCauldronBlock(BlockBehaviour.Properties properties) {
        super(properties, Map.of());
    }

    public Item m_5456_() {
        return Items.f_42544_;
    }

    public abstract IntegerProperty getLevelProperty();

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        return (Integer)state.m_61143_((Property)this.getLevelProperty());
    }

    public void m_141997_(BlockState state, Level level, BlockPos pos, Biome.Precipitation precipitation) {
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new LiquidCauldronBlockTile(pos, state);
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (this.m_151979_(state, pos, entity)) {
            BlockEntity blockEntity;
            if (level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof LiquidCauldronBlockTile) {
                LiquidCauldronBlockTile tile = (LiquidCauldronBlockTile)blockEntity;
                int color = tile.getSoftFluidTank().getCachedParticleColor((BlockAndTintGetter)level, pos);
                int light = tile.getSoftFluidTank().getFluidValue().getEmissivity();
                ModCauldronBlock.playSplashAnimation(level, pos, entity, this.m_142446_(state), color, light);
            }
            super.m_142072_(level, state, pos, entity, 0.0f);
        } else {
            super.m_142072_(level, state, pos, entity, fallDistance);
        }
    }

    public static void playSplashAnimation(Level level, BlockPos pos, Entity e, double waterLevel, int color, int light) {
        Entity feetEntity = e.m_20160_() && e.m_6688_() != null ? e.m_6688_() : e;
        float offset = feetEntity == e ? 0.2f : 0.9f;
        Vec3 movement = feetEntity.m_20184_();
        RandomSource rand = level.f_46441_;
        float speed = Math.min(1.0f, (float)Math.sqrt(movement.f_82479_ * movement.f_82479_ * 0.2 + movement.f_82480_ * movement.f_82480_ + movement.f_82481_ * movement.f_82481_ * 0.2) * offset);
        if (speed < 0.25f) {
            level.m_7785_(e.m_20185_(), e.m_20186_(), e.m_20189_(), e.m_5509_(), e.m_5720_(), speed, 1.0f + (rand.m_188501_() - rand.m_188501_()) * 0.4f, false);
        } else {
            level.m_7785_(e.m_20185_(), e.m_20186_(), e.m_20189_(), e.m_5508_(), e.m_5720_(), speed, 1.0f + (rand.m_188501_() - rand.m_188501_()) * 0.4f, false);
        }
        double surface = (double)pos.m_123342_() + waterLevel;
        float radius = 1.5f;
        float width = e.m_20205_();
        ModCauldronBlock.spawnSplashParticles(level, e, pos, rand, surface, color, light, (ParticleOptions)ModRegistry.BOILING_PARTICLE.get(), radius, width);
        ModCauldronBlock.spawnSplashParticles(level, e, pos, rand, surface, color, light, (ParticleOptions)ModRegistry.SPLASH_PARTICLE.get(), radius, width);
        e.m_146850_(GameEvent.f_157784_);
    }

    private static void spawnSplashParticles(Level level, Entity e, BlockPos pos, RandomSource rand, double surface, int color, int light, ParticleOptions particleOptions, float radius, float width) {
        float mx = (float)pos.m_123341_() + 0.125f;
        float Mx = (float)(pos.m_123341_() + 1) - 0.125f;
        float mz = (float)pos.m_123343_() + 0.125f;
        float Mz = (float)(pos.m_123343_() + 1) - 0.125f;
        int i = 0;
        while ((float)i < 1.0f + width * 20.0f) {
            double x = e.m_20185_() + (rand.m_188500_() - 0.5) * (double)width * (double)radius;
            double z = e.m_20189_() + (rand.m_188500_() - 0.5) * (double)width * (double)radius;
            if (x >= (double)mx && x <= (double)Mx && z >= (double)mz && z <= (double)Mz) {
                level.m_7106_(particleOptions, x, surface, z, (double)color, surface, (double)light);
            }
            ++i;
        }
    }

    public static void playExtinguishSound(Level level, BlockPos pos, Entity entity) {
        level.m_5594_(null, pos, SoundEvents.f_11914_, entity.m_5720_(), 0.7f, 1.6f + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.4f);
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (this.m_151979_(state, pos, entity)) {
            entity.f_19798_ = true;
            if (level.f_46443_) {
                return;
            }
            if (entity.m_6060_()) {
                BlockEntity blockEntity;
                entity.m_20095_();
                ModCauldronBlock.playExtinguishSound(level, pos, entity);
                if (entity.m_142265_(level, pos) && (blockEntity = level.m_7702_(pos)) instanceof LiquidCauldronBlockTile) {
                    LiquidCauldronBlockTile te = (LiquidCauldronBlockTile)blockEntity;
                    te.consumeOneLayer();
                }
            }
            this.handleEntityInside(state, level, pos, entity);
        }
    }

    protected abstract void handleEntityInside(BlockState var1, Level var2, BlockPos var3, Entity var4);

    public void doCraftItem(Level level, BlockPos pos, Player player, InteractionHand hand, LiquidCauldronBlockTile te, SoftFluidStack fluid, ItemStack itemStack, ItemStack crafted, float layerPerItem, int itemCountMultiplier) {
        level.m_5594_(player, pos, SoundEvents.f_11778_, SoundSource.BLOCKS, 1.0f, 1.3f);
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        player.m_36246_(Stats.f_12982_.m_12902_((Object)itemStack.m_41720_()));
        CriteriaTriggers.f_10562_.m_285767_(serverPlayer, pos, itemStack);
        int maxRecolorable = (int)((float)(crafted.m_41613_() * itemCountMultiplier * fluid.getCount()) / layerPerItem);
        int amountToRecolor = Math.min(maxRecolorable, itemStack.m_41613_());
        crafted.m_41764_(amountToRecolor);
        if (!player.m_7500_()) {
            itemStack.m_41774_(amountToRecolor);
            fluid.shrink(Mth.m_14167_((float)(layerPerItem * (float)amountToRecolor / (float)itemCountMultiplier)));
            te.m_6596_();
        }
        if (itemStack.m_41619_()) {
            player.m_21008_(hand, crafted);
        } else if (!player.m_150109_().m_36054_(crafted)) {
            player.m_36176_(crafted, false);
        }
    }

    public abstract BlockState updateStateOnFluidChange(BlockState var1, Level var2, BlockPos var3, SoftFluidStack var4);

    public static void addSurfaceParticles(ParticleOptions type, Level level, BlockPos pos, int count, double surface, RandomSource rand, float r, float g, float b) {
        for (int i = 0; i < count; ++i) {
            double x = (double)pos.m_123341_() + 0.1875 + (double)rand.m_188501_() * 0.625;
            double y = (double)pos.m_123342_() + surface;
            double z = (double)pos.m_123343_() + 0.1875 + (double)rand.m_188501_() * 0.625;
            level.m_7106_(type, x, y, z, (double)r, (double)g, (double)b);
        }
    }
}

