/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.peripheral;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.pocket.IPocketAccess;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleSide;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.BlockEntityPeripheralOwner;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.IPeripheralOwner;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.PocketPeripheralOwner;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.TurtlePeripheralOwner;
import de.srendi.advancedperipherals.common.blocks.base.PeripheralBlockEntity;
import de.srendi.advancedperipherals.common.configuration.APConfig;
import de.srendi.advancedperipherals.common.util.CoordUtil;
import de.srendi.advancedperipherals.common.util.LuaConverter;
import de.srendi.advancedperipherals.lib.peripherals.BasePeripheral;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.server.ServerLifecycleHooks;

public class PlayerDetectorPeripheral
extends BasePeripheral<IPeripheralOwner> {
    public static final String PERIPHERAL_TYPE = "playerDetector";
    private static final int MAX_RANGE = (Integer)APConfig.PERIPHERALS_CONFIG.playerDetMaxRange.get();

    public PlayerDetectorPeripheral(PeripheralBlockEntity<?> tileEntity) {
        super(PERIPHERAL_TYPE, new BlockEntityPeripheralOwner(tileEntity));
    }

    public PlayerDetectorPeripheral(ITurtleAccess access, TurtleSide side) {
        super(PERIPHERAL_TYPE, new TurtlePeripheralOwner(access, side));
    }

    public PlayerDetectorPeripheral(IPocketAccess pocket) {
        super(PERIPHERAL_TYPE, new PocketPeripheralOwner(pocket));
    }

    private boolean isAllowedMultiDimensional() {
        int maxRange = MAX_RANGE;
        return (Boolean)APConfig.PERIPHERALS_CONFIG.playerDetMultiDimensional.get() != false && (maxRange == -1 || maxRange >= 100000000);
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)APConfig.PERIPHERALS_CONFIG.enablePlayerDetector.get();
    }

    @LuaFunction(mainThread=true)
    public final String[] getOnlinePlayers() {
        return ServerLifecycleHooks.getCurrentServer().m_7641_();
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getPlayersInCoords(Map<?, ?> firstCoord, Map<?, ?> secondCoord) throws LuaException {
        ArrayList<String> playersName = new ArrayList<String>();
        BlockPos firstPos = LuaConverter.convertToBlockPos(firstCoord);
        BlockPos secondPos = LuaConverter.convertToBlockPos(secondCoord);
        ResourceKey dimension = this.getLevel().m_46472_();
        for (ServerPlayer player : this.getPlayers()) {
            if (!this.isAllowedMultiDimensional() && player.m_9236_().m_46472_() != dimension || !CoordUtil.isInRange(this.getPos(), (Player)player, this.getLevel(), firstPos, secondPos, MAX_RANGE)) continue;
            playersName.add(player.m_7755_().getString());
        }
        return MethodResult.of(playersName);
    }

    @LuaFunction(mainThread=true)
    public final List<String> getPlayersInCubic(int x, int y, int z) {
        ArrayList<String> playersName = new ArrayList<String>();
        ResourceKey dimension = this.getLevel().m_46472_();
        for (ServerPlayer player : this.getPlayers()) {
            if (!this.isAllowedMultiDimensional() && player.m_9236_().m_46472_() != dimension || !CoordUtil.isInRange(this.getPos(), this.getLevel(), (Player)player, x, y, z, MAX_RANGE)) continue;
            playersName.add(player.m_7755_().getString());
        }
        return playersName;
    }

    @LuaFunction(mainThread=true)
    public final List<String> getPlayersInRange(int range) {
        ArrayList<String> playersName = new ArrayList<String>();
        ResourceKey dimension = this.getLevel().m_46472_();
        for (ServerPlayer player : this.getPlayers()) {
            if (!this.isAllowedMultiDimensional() && player.m_9236_().m_46472_() != dimension || range != -1 && !CoordUtil.isInRange(this.getPos(), this.getLevel(), (Player)player, range, MAX_RANGE)) continue;
            playersName.add(player.m_7755_().getString());
        }
        return playersName;
    }

    @LuaFunction(mainThread=true)
    public final boolean isPlayersInCoords(Map<?, ?> firstCoord, Map<?, ?> secondCoord) throws LuaException {
        if (this.getPlayers().isEmpty()) {
            return false;
        }
        BlockPos firstPos = LuaConverter.convertToBlockPos(firstCoord);
        BlockPos secondPos = LuaConverter.convertToBlockPos(secondCoord);
        ResourceKey dimension = this.getLevel().m_46472_();
        for (ServerPlayer player : this.getPlayers()) {
            if (!this.isAllowedMultiDimensional() && player.m_9236_().m_46472_() != dimension || !CoordUtil.isInRange(this.getPos(), (Player)player, this.getLevel(), firstPos, secondPos, MAX_RANGE)) continue;
            return true;
        }
        return false;
    }

    @LuaFunction(mainThread=true)
    public final boolean isPlayersInCubic(int x, int y, int z) {
        if (this.getPlayers().isEmpty()) {
            return false;
        }
        ResourceKey dimension = this.getLevel().m_46472_();
        for (ServerPlayer player : this.getPlayers()) {
            if (!this.isAllowedMultiDimensional() && player.m_9236_().m_46472_() != dimension || !CoordUtil.isInRange(this.getPos(), this.getLevel(), (Player)player, x, y, z, MAX_RANGE)) continue;
            return true;
        }
        return false;
    }

    @LuaFunction(mainThread=true)
    public final boolean isPlayersInRange(int range) {
        if (this.getPlayers().isEmpty()) {
            return false;
        }
        ResourceKey dimension = this.getLevel().m_46472_();
        for (ServerPlayer player : this.getPlayers()) {
            if (!this.isAllowedMultiDimensional() && player.m_9236_().m_46472_() != dimension || range != -1 && !CoordUtil.isInRange(this.getPos(), this.getLevel(), (Player)player, range, MAX_RANGE)) continue;
            return true;
        }
        return false;
    }

    @LuaFunction(mainThread=true)
    public final boolean isPlayerInCoords(Map<?, ?> firstCoord, Map<?, ?> secondCoord, String username) throws LuaException {
        BlockPos firstPos = LuaConverter.convertToBlockPos(firstCoord);
        BlockPos secondPos = LuaConverter.convertToBlockPos(secondCoord);
        ResourceKey dimension = this.getLevel().m_46472_();
        for (Player player : this.getPlayers()) {
            if (!this.isAllowedMultiDimensional() && player.m_9236_().m_46472_() != dimension || !CoordUtil.isInRange(this.getPos(), player, this.getLevel(), firstPos, secondPos, MAX_RANGE) || !player.m_7755_().getString().equals(username)) continue;
            return true;
        }
        return false;
    }

    @LuaFunction(mainThread=true)
    public final boolean isPlayerInCubic(int x, int y, int z, String username) {
        ResourceKey dimension = this.getLevel().m_46472_();
        for (Player player : this.getPlayers()) {
            if (!this.isAllowedMultiDimensional() && player.m_9236_().m_46472_() != dimension || !CoordUtil.isInRange(this.getPos(), this.getLevel(), player, x, y, z, MAX_RANGE) || !player.m_7755_().getString().equals(username)) continue;
            return true;
        }
        return false;
    }

    @LuaFunction(mainThread=true)
    public final boolean isPlayerInRange(int range, String username) {
        ResourceKey dimension = this.getLevel().m_46472_();
        for (Player player : this.getPlayers()) {
            if (!this.isAllowedMultiDimensional() && player.m_9236_().m_46472_() != dimension || range != -1 && !CoordUtil.isInRange(this.getPos(), this.getLevel(), player, range, MAX_RANGE) || !player.m_7755_().getString().equals(username)) continue;
            return true;
        }
        return false;
    }

    @LuaFunction(value={"getPlayerPos", "getPlayer"}, mainThread=true)
    public final Map<String, Object> getPlayerPos(IArguments arguments) throws LuaException {
        if (!((Boolean)APConfig.PERIPHERALS_CONFIG.playerSpy.get()).booleanValue()) {
            throw new LuaException("This function is disabled in the config. Activate it or ask an admin if he can activate it.");
        }
        ResourceKey dimension = this.getLevel().m_46472_();
        ServerPlayer existingPlayer = null;
        for (ServerPlayer player : this.getPlayers()) {
            if (!this.isAllowedMultiDimensional() && player.m_9236_().m_46472_() != dimension || !player.m_7755_().getString().equals(arguments.getString(0))) continue;
            if (MAX_RANGE != -1 && !CoordUtil.isInRange(this.getPos(), this.getLevel(), (Player)player, MAX_RANGE, MAX_RANGE)) break;
            existingPlayer = player;
            break;
        }
        if (existingPlayer == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> info = new HashMap<String, Object>();
        double x = existingPlayer.m_20185_();
        double y = existingPlayer.m_20186_();
        double z = existingPlayer.m_20189_();
        if (((Boolean)APConfig.PERIPHERALS_CONFIG.playerSpyRandError.get()).booleanValue()) {
            int minDistance = (Integer)APConfig.PERIPHERALS_CONFIG.playerSpyPreciseMaxRange.get();
            int maxError = (Integer)APConfig.PERIPHERALS_CONFIG.playerSpyRandErrorAmount.get();
            int maxDistance = MAX_RANGE == -1 ? 10000 : Math.min(MAX_RANGE, 10000);
            double sublinearFactor = 0.8;
            double yAxisWeight = 0.25;
            maxDistance = Math.max(minDistance, maxDistance);
            double distanceFromPlayer = Math.sqrt(Math.pow(x - (double)this.getPos().m_123341_(), 2.0) + Math.pow(y - (double)this.getPos().m_123342_(), 2.0) + Math.pow(z - (double)this.getPos().m_123343_(), 2.0));
            if ((distanceFromPlayer -= (double)minDistance) > 0.0) {
                double error = (double)maxError * Math.min(Math.pow(distanceFromPlayer / (double)maxDistance, sublinearFactor), 1.0);
                x += (Math.random() - 0.5) * 2.0 * error;
                y += (Math.random() - 0.5) * 2.0 * error * yAxisWeight;
                z += (Math.random() - 0.5) * 2.0 * error;
            }
        }
        int decimals = Math.min(arguments.optInt(1, 0), 4);
        info.put("x", Math.floor(x * Math.pow(10.0, decimals)) / Math.pow(10.0, decimals));
        info.put("y", Math.floor(y * Math.pow(10.0, decimals)) / Math.pow(10.0, decimals));
        info.put("z", Math.floor(z * Math.pow(10.0, decimals)) / Math.pow(10.0, decimals));
        if (((Boolean)APConfig.PERIPHERALS_CONFIG.morePlayerInformation.get()).booleanValue()) {
            info.put("yaw", Float.valueOf(existingPlayer.f_19859_));
            info.put("pitch", Float.valueOf(existingPlayer.f_19860_));
            info.put("dimension", existingPlayer.m_9236_().m_46472_().m_135782_().toString());
            info.put("eyeHeight", Float.valueOf(existingPlayer.m_20192_()));
            info.put("health", Float.valueOf(existingPlayer.m_21223_()));
            info.put("maxHeatlh", Float.valueOf(existingPlayer.m_21233_()));
            info.put("airSupply", existingPlayer.m_20146_());
            info.put("respawnPosition", LuaConverter.posToObject(existingPlayer.m_8961_()));
            info.put("respawnDimension", existingPlayer.m_8963_().m_135782_().toString());
            info.put("respawnAngle", Float.valueOf(existingPlayer.m_8962_()));
        }
        return info;
    }

    private List<ServerPlayer> getPlayers() {
        return ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_();
    }
}

