/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.appliedenergistics;

import appeng.api.inventories.InternalInventory;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.crafting.CraftingJobStatus;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.crafting.ICraftingService;
import appeng.api.networking.storage.IStorageService;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.AEKeyFilter;
import appeng.api.storage.IStorageProvider;
import appeng.api.storage.MEStorage;
import appeng.api.storage.cells.IBasicCellItem;
import appeng.blockentity.storage.DriveBlockEntity;
import appeng.parts.storagebus.StorageBusPart;
import com.the9grounds.aeadditions.item.storage.StorageCell;
import com.the9grounds.aeadditions.item.storage.SuperStorageCell;
import dan200.computercraft.shared.util.NBTUtil;
import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.common.addons.APAddons;
import de.srendi.advancedperipherals.common.util.LuaConverter;
import de.srendi.advancedperipherals.common.util.Pair;
import de.srendi.advancedperipherals.common.util.inventory.FluidFilter;
import de.srendi.advancedperipherals.common.util.inventory.ItemFilter;
import de.srendi.advancedperipherals.common.util.inventory.ItemUtil;
import io.github.projectet.ae2things.item.DISKDrive;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.ramidzkh.mekae2.ae2.MekanismKey;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class AppEngApi {
    public static Pair<Long, AEItemKey> findAEStackFromStack(MEStorage monitor, @Nullable ICraftingService crafting, ItemStack item) {
        return AppEngApi.findAEStackFromFilter(monitor, crafting, ItemFilter.fromStack(item));
    }

    public static Pair<Long, AEItemKey> findAEStackFromFilter(MEStorage monitor, @Nullable ICraftingService crafting, ItemFilter item) {
        AEItemKey key;
        for (Object2LongMap.Entry temp : monitor.getAvailableStacks()) {
            Object object = temp.getKey();
            if (!(object instanceof AEItemKey) || !item.test((key = (AEItemKey)object).toStack())) continue;
            return Pair.of(temp.getLongValue(), key);
        }
        if (crafting == null) {
            return Pair.of(0L, AEItemKey.of((ItemStack)ItemStack.f_41583_));
        }
        for (Object2LongMap.Entry temp : crafting.getCraftables(param -> true)) {
            if (!(temp instanceof AEItemKey) || !item.test((key = (AEItemKey)temp).toStack())) continue;
            return Pair.of(0L, key);
        }
        return Pair.of(0L, AEItemKey.of((ItemStack)ItemStack.f_41583_));
    }

    public static Pair<Long, AEFluidKey> findAEFluidFromStack(MEStorage monitor, @Nullable ICraftingService crafting, FluidStack item) {
        return AppEngApi.findAEFluidFromFilter(monitor, crafting, FluidFilter.fromStack(item));
    }

    public static Pair<Long, AEFluidKey> findAEFluidFromFilter(MEStorage monitor, @Nullable ICraftingService crafting, FluidFilter item) {
        AEFluidKey key;
        for (Object2LongMap.Entry temp : monitor.getAvailableStacks()) {
            Object object = temp.getKey();
            if (!(object instanceof AEFluidKey) || !item.test((key = (AEFluidKey)object).toStack(1))) continue;
            return Pair.of(temp.getLongValue(), key);
        }
        if (crafting == null) {
            return null;
        }
        for (Object2LongMap.Entry temp : crafting.getCraftables(param -> true)) {
            if (!(temp instanceof AEFluidKey) || !item.test((key = (AEFluidKey)temp).toStack(1))) continue;
            return Pair.of(0L, key);
        }
        return null;
    }

    public static List<Object> listStacks(MEStorage monitor, ICraftingService service) {
        ArrayList<Object> items = new ArrayList<Object>();
        KeyCounter keyCounter = monitor.getAvailableStacks();
        for (Object2LongMap.Entry aeKey : keyCounter) {
            Object object = aeKey.getKey();
            if (!(object instanceof AEItemKey)) continue;
            AEItemKey itemKey = (AEItemKey)object;
            items.add(AppEngApi.getObjectFromStack(Pair.of(aeKey.getLongValue(), itemKey), service));
        }
        return items;
    }

    public static List<Object> listCraftableStacks(MEStorage monitor, ICraftingService service) {
        ArrayList<Object> items = new ArrayList<Object>();
        KeyCounter keyCounter = monitor.getAvailableStacks();
        Set craftables = service.getCraftables(AEKeyFilter.none());
        for (AEKey aeKey : craftables) {
            if (!(aeKey instanceof AEItemKey)) continue;
            items.add(AppEngApi.getObjectFromStack(Pair.of(keyCounter.get(aeKey), aeKey), service));
        }
        return items;
    }

    public static List<Object> listFluids(MEStorage monitor, ICraftingService service) {
        ArrayList<Object> items = new ArrayList<Object>();
        for (Object2LongMap.Entry aeKey : monitor.getAvailableStacks()) {
            Object object = aeKey.getKey();
            if (!(object instanceof AEFluidKey)) continue;
            AEFluidKey itemKey = (AEFluidKey)object;
            items.add(AppEngApi.getObjectFromStack(Pair.of(aeKey.getLongValue(), itemKey), service));
        }
        return items;
    }

    public static List<Object> listGases(MEStorage monitor, ICraftingService service, int flag) {
        ArrayList<Object> items = new ArrayList<Object>();
        for (Object2LongMap.Entry aeKey : monitor.getAvailableStacks()) {
            Object object;
            if (!APAddons.appMekLoaded || !((object = aeKey.getKey()) instanceof MekanismKey)) continue;
            MekanismKey itemKey = (MekanismKey)object;
            items.add(AppEngApi.getObjectFromStack(Pair.of(aeKey.getLongValue(), itemKey), service));
        }
        return items;
    }

    public static List<Object> listCraftableFluids(MEStorage monitor, ICraftingService service) {
        ArrayList<Object> items = new ArrayList<Object>();
        KeyCounter keyCounter = monitor.getAvailableStacks();
        Set craftables = service.getCraftables(AEKeyFilter.none());
        for (AEKey aeKey : craftables) {
            if (!(aeKey instanceof AEFluidKey)) continue;
            items.add(AppEngApi.getObjectFromStack(Pair.of(keyCounter.get(aeKey), aeKey), service));
        }
        return items;
    }

    public static <T extends AEKey> Map<String, Object> getObjectFromStack(Pair<Long, T> stack, @Nullable ICraftingService service) {
        if (stack.getRight() == null) {
            return Collections.emptyMap();
        }
        T t = stack.getRight();
        if (t instanceof AEItemKey) {
            AEItemKey itemKey = (AEItemKey)t;
            return AppEngApi.getObjectFromItemStack(Pair.of(stack.getLeft(), itemKey), service);
        }
        t = stack.getRight();
        if (t instanceof AEFluidKey) {
            AEFluidKey fluidKey = (AEFluidKey)t;
            return AppEngApi.getObjectFromFluidStack(Pair.of(stack.getLeft(), fluidKey), service);
        }
        if (APAddons.appMekLoaded && (t = stack.getRight()) instanceof MekanismKey) {
            MekanismKey gasKey = (MekanismKey)t;
            return AppEngApi.getObjectFromGasStack(Pair.of(stack.getLeft(), gasKey), service);
        }
        AdvancedPeripherals.debug("Could not create table from unknown stack " + ((AEKey)stack.getRight()).getClass() + " - Report this to the maintainer of ap", org.apache.logging.log4j.Level.ERROR);
        return Collections.emptyMap();
    }

    private static Map<String, Object> getObjectFromItemStack(Pair<Long, AEItemKey> stack, @Nullable ICraftingService craftingService) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String displayName = stack.getRight().getDisplayName().getString();
        CompoundTag nbt = stack.getRight().toTag();
        long amount = stack.getLeft();
        map.put("fingerprint", ItemUtil.getFingerprint(stack.getRight().toStack()));
        map.put("name", ItemUtil.getRegistryKey(stack.getRight().getItem()).toString());
        map.put("amount", amount);
        map.put("displayName", displayName);
        map.put("nbt", NBTUtil.toLua((Tag)nbt));
        map.put("tags", LuaConverter.tagsToList(() -> ((AEItemKey)stack.getRight()).getItem().m_204114_().m_203616_()));
        map.put("isCraftable", craftingService != null && craftingService.isCraftable((AEKey)stack.getRight()));
        return map;
    }

    private static Map<String, Object> getObjectFromFluidStack(Pair<Long, AEFluidKey> stack, @Nullable ICraftingService craftingService) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        long amount = stack.getLeft();
        map.put("name", ForgeRegistries.FLUIDS.getKey((Object)stack.getRight().getFluid()).toString());
        map.put("amount", amount);
        map.put("displayName", stack.getRight().getDisplayName().getString());
        map.put("tags", LuaConverter.tagsToList(() -> ((AEFluidKey)stack.getRight()).getFluid().m_205069_().m_203616_()));
        map.put("isCraftable", craftingService != null && craftingService.isCraftable((AEKey)stack.getRight()));
        return map;
    }

    private static Map<String, Object> getObjectFromGasStack(Pair<Long, MekanismKey> stack, @Nullable ICraftingService craftingService) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        long amount = stack.getLeft();
        map.put("name", stack.getRight().getStack().getTypeRegistryName().toString());
        map.put("amount", amount);
        map.put("displayName", stack.getRight().getDisplayName().getString());
        map.put("tags", LuaConverter.tagsToList(() -> ((MekanismKey)stack.getRight()).getStack().getType().getTags()));
        return map;
    }

    public static Map<String, Object> getObjectFromCPU(ICraftingCPU cpu) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        long storage = cpu.getAvailableStorage();
        int coProcessors = cpu.getCoProcessors();
        boolean isBusy = cpu.isBusy();
        map.put("storage", storage);
        map.put("coProcessors", coProcessors);
        map.put("isBusy", isBusy);
        map.put("craftingJob", cpu.getJobStatus() != null ? AppEngApi.getObjectFromJob(cpu.getJobStatus()) : null);
        map.put("name", cpu.getName() != null ? cpu.getName().getString() : "Unnamed");
        map.put("selectionMode", cpu.getSelectionMode().toString());
        return map;
    }

    public static Map<String, Object> getObjectFromJob(CraftingJobStatus job) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("storage", AppEngApi.getObjectFromGenericStack(job.crafting()));
        map.put("elapsedTimeNanos", job.elapsedTimeNanos());
        map.put("totalItem", job.totalItems());
        map.put("progress", job.progress());
        return map;
    }

    public static Map<String, Object> getObjectFromGenericStack(GenericStack stack) {
        if (stack.what() == null) {
            return Collections.emptyMap();
        }
        AEKey aEKey = stack.what();
        if (aEKey instanceof AEItemKey) {
            AEItemKey aeItemKey = (AEItemKey)aEKey;
            return AppEngApi.getObjectFromItemStack(Pair.of(stack.amount(), aeItemKey), null);
        }
        aEKey = stack.what();
        if (aEKey instanceof AEFluidKey) {
            AEFluidKey aeFluidKey = (AEFluidKey)aEKey;
            return AppEngApi.getObjectFromFluidStack(Pair.of(stack.amount(), aeFluidKey), null);
        }
        return Collections.emptyMap();
    }

    public static MEStorage getMonitor(IGridNode node) {
        return ((IStorageService)node.getGrid().getService(IStorageService.class)).getInventory();
    }

    public static boolean isItemCrafting(MEStorage monitor, ICraftingService grid, ItemFilter filter, @Nullable ICraftingCPU craftingCPU) {
        Pair<Long, AEItemKey> stack = AppEngApi.findAEStackFromFilter(monitor, grid, filter);
        if (stack == null) {
            return false;
        }
        if (craftingCPU == null) {
            for (ICraftingCPU cpu : grid.getCpus()) {
                CraftingJobStatus jobStatus;
                if (!cpu.isBusy() || (jobStatus = cpu.getJobStatus()) == null || !jobStatus.crafting().what().equals(stack.getRight())) continue;
                return true;
            }
        } else if (craftingCPU.isBusy()) {
            CraftingJobStatus jobStatus = craftingCPU.getJobStatus();
            if (jobStatus == null) {
                return false;
            }
            return jobStatus.crafting().what().equals(stack.getRight());
        }
        return false;
    }

    public static boolean isFluidCrafting(MEStorage monitor, ICraftingService grid, FluidFilter filter, @Nullable ICraftingCPU craftingCPU) {
        Pair<Long, AEFluidKey> stack = AppEngApi.findAEFluidFromFilter(monitor, grid, filter);
        if (stack == null) {
            return false;
        }
        if (craftingCPU == null) {
            for (ICraftingCPU cpu : grid.getCpus()) {
                CraftingJobStatus jobStatus;
                if (!cpu.isBusy() || (jobStatus = cpu.getJobStatus()) == null || !jobStatus.crafting().what().equals(stack.getRight())) continue;
                return true;
            }
        } else if (craftingCPU.isBusy()) {
            CraftingJobStatus jobStatus = craftingCPU.getJobStatus();
            if (jobStatus == null) {
                return false;
            }
            return jobStatus.crafting().what().equals(stack.getRight());
        }
        return false;
    }

    public static long getTotalItemStorage(IGridNode node) {
        long total = 0L;
        Iterator iterator = node.getGrid().getNodes().iterator();
        while (iterator.hasNext()) {
            IGridNodeService iGridNodeService = ((IGridNode)iterator.next()).getService(IStorageProvider.class);
            if (!(iGridNodeService instanceof DriveBlockEntity)) continue;
            DriveBlockEntity entity = (DriveBlockEntity)iGridNodeService;
            InternalInventory inventory = entity.getInternalInventory();
            for (int i = 0; i < inventory.size(); ++i) {
                StorageCell storageCell;
                ItemStack stack = inventory.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                Item item = stack.m_41720_();
                if (item instanceof IBasicCellItem) {
                    IBasicCellItem cell = (IBasicCellItem)item;
                    if (!cell.getKeyType().getClass().isAssignableFrom(AEKeyType.items().getClass())) continue;
                    total += (long)cell.getBytes(null);
                    continue;
                }
                if (APAddons.aeThingsLoaded && (item = stack.m_41720_()) instanceof DISKDrive) {
                    DISKDrive disk = (DISKDrive)item;
                    if (!disk.getKeyType().toString().equals("ae2:i")) continue;
                    total += (long)disk.getBytes(null);
                    continue;
                }
                if (APAddons.aeAdditionsLoaded && (item = stack.m_41720_()) instanceof SuperStorageCell) {
                    SuperStorageCell superStorageCell = (SuperStorageCell)item;
                    total += (long)superStorageCell.getKiloBytes() * 1024L;
                    continue;
                }
                if (APAddons.aeAdditionsLoaded && (item = stack.m_41720_()) instanceof StorageCell) {
                    StorageCell storageCell2 = (StorageCell)item;
                    if (storageCell2.getKeyType() != AEKeyType.items()) continue;
                    total += (long)storageCell2.getKiloBytes() * 1024L;
                    continue;
                }
                if (!APAddons.aeAdditionsLoaded || !((item = stack.m_41720_()) instanceof StorageCell) || (storageCell = (StorageCell)item).getKeyType() != AEKeyType.items()) continue;
                total += (long)(storageCell.getKiloBytes() * 1024);
            }
        }
        iterator = node.getGrid().getMachineNodes(StorageBusPart.class).iterator();
        while (iterator.hasNext()) {
            BlockPos connectedInventoryPos;
            StorageBusPart bus = (StorageBusPart)((IGridNode)iterator.next()).getService(IStorageProvider.class);
            Level level = bus.getLevel();
            BlockEntity connectedInventoryEntity = level.m_7702_(connectedInventoryPos = bus.getHost().getBlockEntity().m_58899_().m_121945_(bus.getSide()));
            LazyOptional itemHandler = connectedInventoryEntity.getCapability(ForgeCapabilities.ITEM_HANDLER);
            if (!itemHandler.isPresent()) continue;
            IItemHandler handler = (IItemHandler)itemHandler.orElse(null);
            for (int i = 0; i < handler.getSlots(); ++i) {
                total += (long)handler.getSlotLimit(i);
            }
        }
        return total;
    }

    public static long getTotalFluidStorage(IGridNode node) {
        long total = 0L;
        Iterator iterator = node.getGrid().getNodes().iterator();
        while (iterator.hasNext()) {
            IGridNodeService iGridNodeService = ((IGridNode)iterator.next()).getService(IStorageProvider.class);
            if (!(iGridNodeService instanceof DriveBlockEntity)) continue;
            DriveBlockEntity entity = (DriveBlockEntity)iGridNodeService;
            InternalInventory inventory = entity.getInternalInventory();
            for (int i = 0; i < inventory.size(); ++i) {
                StorageCell storageCell;
                ItemStack stack = inventory.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                Item item = stack.m_41720_();
                if (item instanceof IBasicCellItem) {
                    IBasicCellItem cell = (IBasicCellItem)item;
                    if (!cell.getKeyType().getClass().isAssignableFrom(AEKeyType.fluids().getClass())) continue;
                    total += (long)cell.getBytes(null);
                    continue;
                }
                if (APAddons.aeAdditionsLoaded && (item = stack.m_41720_()) instanceof SuperStorageCell) {
                    SuperStorageCell superStorageCell = (SuperStorageCell)item;
                    total += (long)superStorageCell.getKiloBytes() * 1024L;
                    continue;
                }
                if (APAddons.aeAdditionsLoaded && (item = stack.m_41720_()) instanceof StorageCell) {
                    StorageCell storageCell2 = (StorageCell)item;
                    if (storageCell2.getKeyType() != AEKeyType.fluids()) continue;
                    total += (long)storageCell2.getKiloBytes() * 1024L;
                    continue;
                }
                if (!APAddons.aeAdditionsLoaded || !((item = stack.m_41720_()) instanceof StorageCell) || (storageCell = (StorageCell)item).getKeyType() != AEKeyType.fluids()) continue;
                total += (long)(storageCell.getKiloBytes() * 1024);
            }
        }
        iterator = node.getGrid().getMachineNodes(StorageBusPart.class).iterator();
        while (iterator.hasNext()) {
            BlockPos connectedInventoryPos;
            StorageBusPart bus = (StorageBusPart)((IGridNode)iterator.next()).getService(IStorageProvider.class);
            Level level = bus.getLevel();
            BlockEntity connectedInventoryEntity = level.m_7702_(connectedInventoryPos = bus.getHost().getBlockEntity().m_58899_().m_121945_(bus.getSide()));
            LazyOptional fluidHandler = connectedInventoryEntity.getCapability(ForgeCapabilities.FLUID_HANDLER);
            if (!fluidHandler.isPresent()) continue;
            IFluidHandler handler = (IFluidHandler)fluidHandler.orElse(null);
            for (int i = 0; i < handler.getTanks(); ++i) {
                total += (long)handler.getTankCapacity(i);
            }
        }
        return total;
    }

    public static long getUsedItemStorage(IGridNode node) {
        long used = 0L;
        Iterator iterator = node.getGrid().getNodes().iterator();
        while (iterator.hasNext()) {
            IGridNodeService iGridNodeService = ((IGridNode)iterator.next()).getService(IStorageProvider.class);
            if (!(iGridNodeService instanceof DriveBlockEntity)) continue;
            DriveBlockEntity entity = (DriveBlockEntity)iGridNodeService;
            InternalInventory inventory = entity.getInternalInventory();
            for (int i = 0; i < inventory.size(); ++i) {
                StorageCell storageCell;
                Item numItemsInCell3;
                Item bytesPerType2;
                ItemStack stack = inventory.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                Item item = stack.m_41720_();
                if (item instanceof IBasicCellItem) {
                    IBasicCellItem cell = (IBasicCellItem)item;
                    int bytesPerType2 = cell.getBytesPerType(null);
                    if (!cell.getKeyType().getClass().isAssignableFrom(AEKeyType.items().getClass()) || stack.m_41783_() == null) continue;
                    int numOfType = stack.m_41783_().m_128467_("amts").length;
                    long numItemsInCell2 = stack.m_41783_().m_128454_("ic");
                    used += (long)((int)Math.ceil((double)numItemsInCell2 / 8.0)) + (long)bytesPerType2 * (long)numOfType;
                    continue;
                }
                if (APAddons.aeThingsLoaded && (bytesPerType2 = stack.m_41720_()) instanceof DISKDrive) {
                    DISKDrive disk = (DISKDrive)bytesPerType2;
                    if (!disk.getKeyType().toString().equals("ae2:i") || stack.m_41783_() == null) continue;
                    long numBytesInCell = stack.m_41783_().m_128454_("ic");
                    used += numBytesInCell;
                    continue;
                }
                if (APAddons.aeAdditionsLoaded && stack.m_41720_() instanceof SuperStorageCell) {
                    if (stack.m_41783_() == null) continue;
                    long numItemsInCell3 = stack.m_41783_().m_128454_("ic");
                    used += numItemsInCell3;
                    continue;
                }
                if (!APAddons.aeAdditionsLoaded || !((numItemsInCell3 = stack.m_41720_()) instanceof StorageCell) || (storageCell = (StorageCell)numItemsInCell3).getKeyType() != AEKeyType.items() || stack.m_41783_() == null) continue;
                long numItemsInCell4 = stack.m_41783_().m_128454_("ic");
                used += numItemsInCell4;
            }
        }
        iterator = node.getGrid().getMachineNodes(StorageBusPart.class).iterator();
        while (iterator.hasNext()) {
            StorageBusPart bus = (StorageBusPart)((IGridNode)iterator.next()).getService(IStorageProvider.class);
            KeyCounter keyCounter = bus.getInternalHandler().getAvailableStacks();
            for (Object2LongMap.Entry aeKey : keyCounter) {
                if (!(aeKey.getKey() instanceof AEItemKey)) continue;
                used += aeKey.getLongValue();
            }
        }
        return used;
    }

    public static long getUsedFluidStorage(IGridNode node) {
        long used = 0L;
        Iterator iterator = node.getGrid().getNodes().iterator();
        while (iterator.hasNext()) {
            IGridNodeService iGridNodeService = ((IGridNode)iterator.next()).getService(IStorageProvider.class);
            if (!(iGridNodeService instanceof DriveBlockEntity)) continue;
            DriveBlockEntity entity = (DriveBlockEntity)iGridNodeService;
            InternalInventory inventory = entity.getInternalInventory();
            for (int i = 0; i < inventory.size(); ++i) {
                StorageCell storageCell;
                Item numItemsInCell2;
                ItemStack stack = inventory.getStackInSlot(i);
                Item item = stack.m_41720_();
                if (item instanceof IBasicCellItem) {
                    IBasicCellItem cell = (IBasicCellItem)item;
                    int bytesPerType = cell.getBytesPerType(null);
                    if (!cell.getKeyType().getClass().isAssignableFrom(AEKeyType.fluids().getClass()) || stack.m_41783_() == null) continue;
                    int numOfType = stack.m_41783_().m_128467_("amts").length;
                    long numBucketsInCell = stack.m_41783_().m_128454_("ic") / 1000L;
                    used += (long)((int)Math.ceil((double)numBucketsInCell / 8.0)) + (long)bytesPerType * (long)numOfType;
                    continue;
                }
                if (APAddons.aeAdditionsLoaded && stack.m_41720_() instanceof SuperStorageCell) {
                    if (stack.m_41783_() == null) continue;
                    long numItemsInCell2 = stack.m_41783_().m_128454_("ic");
                    used += numItemsInCell2;
                    continue;
                }
                if (!APAddons.aeAdditionsLoaded || !((numItemsInCell2 = stack.m_41720_()) instanceof StorageCell) || (storageCell = (StorageCell)numItemsInCell2).getKeyType() != AEKeyType.fluids() || stack.m_41783_() == null) continue;
                long numItemsInCell3 = stack.m_41783_().m_128454_("ic");
                used += numItemsInCell3;
            }
        }
        iterator = node.getGrid().getMachineNodes(StorageBusPart.class).iterator();
        while (iterator.hasNext()) {
            StorageBusPart bus = (StorageBusPart)((IGridNode)iterator.next()).getService(IStorageProvider.class);
            KeyCounter keyCounter = bus.getInternalHandler().getAvailableStacks();
            for (Object2LongMap.Entry aeKey : keyCounter) {
                Object object = aeKey.getKey();
                if (!(object instanceof AEFluidKey)) continue;
                AEFluidKey fluidKey = (AEFluidKey)object;
                used += aeKey.getLongValue();
            }
        }
        return used;
    }

    public static long getAvailableItemStorage(IGridNode node) {
        return AppEngApi.getTotalItemStorage(node) - AppEngApi.getUsedItemStorage(node);
    }

    public static long getAvailableFluidStorage(IGridNode node) {
        return AppEngApi.getTotalFluidStorage(node) - AppEngApi.getUsedFluidStorage(node);
    }

    public static List<Object> listCells(IGridNode node) {
        ArrayList<Object> items = new ArrayList<Object>();
        Iterator iterator = node.getGrid().getMachineNodes(DriveBlockEntity.class).iterator();
        if (!iterator.hasNext()) {
            return items;
        }
        while (iterator.hasNext()) {
            DriveBlockEntity entity = (DriveBlockEntity)((IGridNode)iterator.next()).getService(IStorageProvider.class);
            if (entity == null) continue;
            InternalInventory inventory = entity.getInternalInventory();
            for (int i = 0; i < inventory.size(); ++i) {
                ItemStack stack = inventory.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                Item item = stack.m_41720_();
                if (item instanceof IBasicCellItem) {
                    IBasicCellItem cell = (IBasicCellItem)item;
                    items.add(AppEngApi.getObjectFromCell(cell, stack));
                    continue;
                }
                if (APAddons.aeThingsLoaded && (item = stack.m_41720_()) instanceof DISKDrive) {
                    DISKDrive disk = (DISKDrive)item;
                    items.add(AppEngApi.getObjectFromDisk(disk, stack));
                    continue;
                }
                if (!APAddons.aeAdditionsLoaded || !((item = stack.m_41720_()) instanceof SuperStorageCell)) continue;
                SuperStorageCell superStorageCell = (SuperStorageCell)item;
                items.add(AppEngApi.getObjectFromSuperCell(superStorageCell, stack));
            }
        }
        return items;
    }

    private static Map<String, Object> getObjectFromCell(IBasicCellItem cell, ItemStack stack) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("item", ItemUtil.getRegistryKey(stack.m_41720_()).toString());
        String cellType = "";
        if (cell.getKeyType().getClass().isAssignableFrom(AEKeyType.items().getClass())) {
            cellType = "item";
        } else if (cell.getKeyType().getClass().isAssignableFrom(AEKeyType.fluids().getClass())) {
            cellType = "fluid";
        }
        map.put("cellType", cellType);
        map.put("bytesPerType", cell.getBytesPerType(null));
        map.put("totalBytes", cell.getBytes(null));
        return map;
    }

    private static Map<String, Object> getObjectFromDisk(DISKDrive drive, ItemStack stack) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("item", stack.m_41720_().toString());
        String cellType = "";
        if (drive.getKeyType().toString().equals("ae2:i")) {
            cellType = "item";
        } else if (drive.getKeyType().toString().equals("ae2:f")) {
            cellType = "fluid";
        }
        map.put("cellType", cellType);
        map.put("totalBytes", drive.getBytes(null));
        return map;
    }

    private static Map<String, Object> getObjectFromSuperCell(SuperStorageCell cell, ItemStack stack) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("item", stack.m_41720_().toString());
        String cellType = "all";
        map.put("cellType", cellType);
        map.put("totalBytes", cell.getBytes(stack));
        return map;
    }
}

