/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.mixin;

import com.endertech.minecraft.forge.blocks.ISmokeContainer;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adchimneys.AdChimneys;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Pseudo
@Mixin(targets={"io.github.mortuusars.sootychimneys.block.ChimneyBlock"})
public abstract class SootyChimneyBlockMixin
extends Block {
    public SootyChimneyBlockMixin(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    @Inject(method={"emitSmokeParticles"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void emitParticles(Level level, BlockState state, double x, double y, double z, boolean signalSmoke, CallbackInfo callback) {
        if (this.shouldDisableParticles(level, x, y, z)) {
            callback.cancel();
        }
    }

    @Inject(method={"emitParticle"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void emitParticle(Level level, double x, double y, double z, ParticleOptions options, CallbackInfo callback) {
        if (this.shouldDisableParticles(level, x, y, z)) {
            callback.cancel();
        }
    }

    @Unique
    private boolean shouldDisableParticles(Level level, double x, double y, double z) {
        BlockPos pos = BlockPos.m_274561_((double)x, (double)y, (double)z).m_7495_();
        while (level.m_46739_(pos)) {
            BlockState state = level.m_8055_(pos);
            if (state.m_60734_() instanceof ISmokeContainer) {
                return true;
            }
            if (AdChimneys.getInstance().emitters.get(state).isPresent()) {
                return true;
            }
            if (!state.m_204336_(GameWorld.SmokeContainers.CHIMNEYS)) break;
            pos = pos.m_7495_();
        }
        return false;
    }
}

