/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.quarry;

import com.google.common.collect.Sets;
import com.yogpc.qp.Holder;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.Area;
import com.yogpc.qp.machines.BreakResult;
import com.yogpc.qp.machines.CheckerLog;
import com.yogpc.qp.machines.EnchantmentHolder;
import com.yogpc.qp.machines.EnchantmentLevel;
import com.yogpc.qp.machines.EnergyCounter;
import com.yogpc.qp.machines.InvUtils;
import com.yogpc.qp.machines.ItemConverter;
import com.yogpc.qp.machines.MachineStorage;
import com.yogpc.qp.machines.PowerConfig;
import com.yogpc.qp.machines.PowerManager;
import com.yogpc.qp.machines.PowerTile;
import com.yogpc.qp.machines.QPBlock;
import com.yogpc.qp.machines.QuarryFakePlayer;
import com.yogpc.qp.machines.TraceQuarryWork;
import com.yogpc.qp.machines.module.FilterModule;
import com.yogpc.qp.machines.module.ModuleInventory;
import com.yogpc.qp.machines.module.QuarryModule;
import com.yogpc.qp.machines.module.QuarryModuleProvider;
import com.yogpc.qp.machines.module.ReplacerModule;
import com.yogpc.qp.machines.quarry.QuarryState;
import com.yogpc.qp.machines.quarry.Target;
import com.yogpc.qp.packet.ClientSync;
import com.yogpc.qp.packet.ClientSyncMessage;
import com.yogpc.qp.packet.PacketHandler;
import com.yogpc.qp.utils.CacheEntry;
import com.yogpc.qp.utils.MapMulti;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class TileQuarry
extends PowerTile
implements CheckerLog,
MachineStorage.HasStorage,
EnchantmentLevel.HasEnchantments,
ClientSync,
ModuleInventory.HasModuleInventory,
PowerConfig.Provider {
    private static final Marker MARKER = MarkerManager.getMarker((String)"TileQuarry");
    @Nullable
    public Target target;
    public QuarryState state = QuarryState.FINISHED;
    @Nullable
    private Area area;
    private List<EnchantmentLevel> enchantments = new ArrayList<EnchantmentLevel>();
    public final MachineStorage storage = new MachineStorage();
    public double headX;
    public double headY;
    public double headZ;
    public double targetHeadX;
    public double targetHeadY;
    public double targetHeadZ;
    private boolean init = false;
    public int digMinY = 0;
    private ItemConverter itemConverter;
    private Set<QuarryModule> modules = new HashSet<QuarryModule>();
    private final ModuleInventory moduleInventory;
    private final QuarryCache cache = new QuarryCache();

    public TileQuarry(BlockPos pos, BlockState state) {
        super(Holder.QUARRY_TYPE, pos, state);
        this.moduleInventory = new ModuleInventory(5, this::updateModules, m -> true, (ModuleInventory.HasModuleInventory)this);
        this.itemConverter = this.createConverter();
    }

    TileQuarry(BlockEntityType<?> entityType, BlockPos pos, BlockState state) {
        super(entityType, pos, state);
        this.moduleInventory = new ModuleInventory(0, () -> {}, m -> false, (ModuleInventory.HasModuleInventory)this);
    }

    @Override
    public void saveNbtData(CompoundTag nbt) {
        if (this.target != null) {
            nbt.m_128365_("target", (Tag)Target.toNbt(this.target));
        }
        nbt.m_128359_("state", this.state.name());
        nbt.m_128365_("storage", (Tag)this.storage.toNbt());
        this.toClientTag(nbt);
        nbt.m_128365_("moduleInventory", (Tag)this.moduleInventory.serializeNBT());
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.target = nbt.m_128441_("target") ? Target.fromNbt(nbt.m_128469_("target")) : null;
        this.state = QuarryState.valueOf(nbt.m_128461_("state"));
        this.storage.readNbt(nbt.m_128469_("storage"));
        this.fromClientTag(nbt);
        this.moduleInventory.deserializeNBT(nbt.m_128469_("moduleInventory"));
        this.init = true;
    }

    @Override
    public CompoundTag toClientTag(CompoundTag tag) {
        if (this.area != null) {
            tag.m_128365_("area", (Tag)this.area.toNBT());
        }
        CompoundTag enchantments = new CompoundTag();
        this.enchantments.forEach(e -> enchantments.m_128405_(Objects.requireNonNull(e.enchantmentID(), "Invalid enchantment. " + e.enchantment()).toString(), e.level()));
        tag.m_128365_("enchantments", (Tag)enchantments);
        tag.m_128359_("state", this.state.name());
        tag.m_128347_("headX", this.headX);
        tag.m_128347_("headY", this.headY);
        tag.m_128347_("headZ", this.headZ);
        tag.m_128405_("digMinY", this.digMinY);
        return tag;
    }

    @Override
    public void fromClientTag(CompoundTag tag) {
        this.area = Area.fromNBT(tag.m_128469_("area")).orElse(null);
        CompoundTag enchantments = tag.m_128469_("enchantments");
        this.setEnchantments(enchantments.m_128431_().stream().mapMulti(MapMulti.getEntry(ForgeRegistries.ENCHANTMENTS, arg_0 -> ((CompoundTag)enchantments).m_128451_(arg_0))).map(EnchantmentLevel::new).sorted(EnchantmentLevel.QUARRY_ENCHANTMENT_COMPARATOR).toList());
        this.state = QuarryState.valueOf(tag.m_128461_("state"));
        this.targetHeadX = tag.m_128459_("headX");
        this.targetHeadY = tag.m_128459_("headY");
        this.targetHeadZ = tag.m_128459_("headZ");
        this.digMinY = tag.m_128451_("digMinY");
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.init = true;
            this.updateModules();
        }
    }

    public void setArea(@Nullable Area area) {
        this.area = area;
        if (TileQuarry.shouldLogQuarryWork()) {
            QuarryPlus.LOGGER.debug(MARKER, "{}({}) Area changed to {}.", (Object)this.getClass().getSimpleName(), (Object)this.m_58899_(), (Object)area);
        }
        if (area != null) {
            this.headX = area.maxX();
            this.headY = area.minY();
            this.headZ = area.maxZ();
        }
    }

    @Nullable
    public Area getArea() {
        return this.area;
    }

    public void setState(QuarryState quarryState, BlockState blockState) {
        if (this.state != quarryState) {
            QuarryState pre = this.state;
            this.state = quarryState;
            this.sync();
            if (this.f_58857_ != null) {
                this.f_58857_.m_7731_(this.m_58899_(), (BlockState)blockState.m_61124_((Property)QPBlock.WORKING, (Comparable)Boolean.valueOf(quarryState.isWorking)), 3);
                if (!this.f_58857_.f_46443_ && QuarryState.FINISHED == quarryState) {
                    this.logUsage();
                    TraceQuarryWork.finishWork(this, this.m_58899_(), this.getEnergyStored());
                }
            }
            if ((pre != QuarryState.MOVE_HEAD && pre != QuarryState.BREAK_BLOCK && pre != QuarryState.REMOVE_FLUID || quarryState == QuarryState.FILLER) && TileQuarry.shouldLogQuarryWork()) {
                QuarryPlus.LOGGER.debug(MARKER, "{}({}) State changed from {} to {}.", (Object)this.getClass().getSimpleName(), (Object)this.m_58899_(), (Object)pre, (Object)quarryState);
                TraceQuarryWork.changeState(this, this.m_58899_(), pre.toString(), quarryState.toString());
            }
        }
    }

    public ServerLevel getTargetWorld() {
        return (ServerLevel)this.m_58904_();
    }

    public static void tick(Level world, BlockPos pos, BlockState state, TileQuarry quarry) {
        if (quarry.hasEnoughEnergy()) {
            if (quarry.init) {
                quarry.updateModules();
                quarry.init = false;
            }
            for (int i = 0; i < quarry.getRepeatWorkCount(); ++i) {
                quarry.state.tick(world, pos, state, quarry);
            }
        }
    }

    public static void clientTick(Level world, BlockPos pos, BlockState state, TileQuarry quarry) {
        quarry.headX = quarry.targetHeadX;
        quarry.headY = quarry.targetHeadY;
        quarry.headZ = quarry.targetHeadZ;
    }

    public BreakResult breakBlock(BlockPos targetPos) {
        return this.breakBlock(targetPos, true);
    }

    public BreakResult breakBlock(BlockPos targetPos, boolean requireEnergy) {
        ServerLevel targetWorld = this.getTargetWorld();
        if (targetPos.m_123341_() % 3 == 0 && targetPos.m_123343_() % 3 == 0) {
            targetWorld.m_6443_(ItemEntity.class, new AABB(targetPos).m_82400_(5.0), Predicate.not(i -> i.m_32055_().m_41619_())).forEach(i -> {
                this.storage.addItem(i.m_32055_());
                i.m_6074_();
            });
            this.getExpModule().ifPresent(e -> targetWorld.m_6443_(ExperienceOrb.class, new AABB(targetPos).m_82400_(5.0), EntitySelector.f_20402_).forEach(orb -> {
                e.addExp(orb.m_20801_());
                orb.m_6074_();
            }));
        }
        ItemStack pickaxe = this.getPickaxe();
        FakePlayer fakePlayer = QuarryFakePlayer.getAndSetPosition(targetWorld, targetPos, pickaxe);
        BlockState state = targetWorld.m_8055_(targetPos);
        BlockEvent.BreakEvent breakEvent = new BlockEvent.BreakEvent((Level)targetWorld, targetPos, state, (Player)fakePlayer);
        MinecraftForge.EVENT_BUS.post((Event)breakEvent);
        if (breakEvent.isCanceled()) {
            TraceQuarryWork.blockRemoveFailed(this, this.m_58899_(), targetPos, state, BreakResult.FAIL_EVENT, new Object[0]);
            if (this.target != null) {
                this.target.addSkipped(targetPos);
            }
            return BreakResult.FAIL_EVENT;
        }
        if (state.m_60795_() || !this.canBreak((Level)targetWorld, targetPos, state)) {
            TraceQuarryWork.blockRemoveFailed(this, this.m_58899_(), targetPos, state, BreakResult.SKIPPED, new Object[0]);
            return BreakResult.SKIPPED;
        }
        if (this.hasPumpModule()) {
            TileQuarry.removeEdgeFluid(targetPos, targetWorld, this, (Entity)fakePlayer);
        }
        float hardness = state.m_60800_((BlockGetter)targetWorld, targetPos);
        long requiredEnergy = PowerManager.getBreakEnergy(hardness, this);
        if (requireEnergy && !this.useEnergy(requiredEnergy, PowerTile.Reason.BREAK_BLOCK, requiredEnergy > this.getMaxEnergy())) {
            TraceQuarryWork.blockRemoveFailed(this, this.m_58899_(), targetPos, state, BreakResult.NOT_ENOUGH_ENERGY, Map.of("required", EnergyCounter.formatEnergyInFE(requiredEnergy), "has", EnergyCounter.formatEnergyInFE(this.getEnergy())));
            return BreakResult.NOT_ENOUGH_ENERGY;
        }
        List<ItemStack> drops = InvUtils.getBlockDrops(state, targetWorld, targetPos, targetWorld.m_7702_(targetPos), (Entity)fakePlayer, pickaxe);
        TraceQuarryWork.blockRemoveSucceed((PowerTile)this, this.m_58899_(), targetPos, state, drops, breakEvent.getExpToDrop(), requiredEnergy);
        drops.stream().map(this.itemConverter::map).forEach(this.storage::addItem);
        targetWorld.m_7731_(targetPos, this.getReplacementState(), 3);
        if (breakEvent.getExpToDrop() > 0) {
            this.getExpModule().ifPresent(e -> {
                if (requireEnergy) {
                    this.useEnergy(PowerManager.getExpCollectEnergy(breakEvent.getExpToDrop(), this), PowerTile.Reason.EXP_COLLECT, true);
                }
                e.addExp(breakEvent.getExpToDrop());
            });
        }
        SoundType sound = state.m_60827_();
        if (requireEnergy) {
            targetWorld.m_5594_(null, targetPos, sound.m_56775_(), SoundSource.BLOCKS, (sound.m_56773_() + 1.0f) / 4.0f, sound.m_56774_() * 0.8f);
        }
        return BreakResult.SUCCESS;
    }

    static void removeEdgeFluid(BlockPos targetPos, ServerLevel targetWorld, TileQuarry quarry, Entity entity) {
        boolean flagMaxZ;
        Area area = quarry.getArea();
        assert (area != null);
        boolean flagMinX = targetPos.m_123341_() - 1 == area.minX();
        boolean flagMaxX = targetPos.m_123341_() + 1 == area.maxX();
        boolean flagMinZ = targetPos.m_123343_() - 1 == area.minZ();
        boolean bl = flagMaxZ = targetPos.m_123343_() + 1 == area.maxZ();
        if (flagMinX) {
            TileQuarry.removeFluidAtPos(targetWorld, new BlockPos(area.minX(), targetPos.m_123342_(), targetPos.m_123343_()), quarry, entity);
        }
        if (flagMaxX) {
            TileQuarry.removeFluidAtPos(targetWorld, new BlockPos(area.maxX(), targetPos.m_123342_(), targetPos.m_123343_()), quarry, entity);
        }
        if (flagMinZ) {
            TileQuarry.removeFluidAtPos(targetWorld, new BlockPos(targetPos.m_123341_(), targetPos.m_123342_(), area.minZ()), quarry, entity);
        }
        if (flagMaxZ) {
            TileQuarry.removeFluidAtPos(targetWorld, new BlockPos(targetPos.m_123341_(), targetPos.m_123342_(), area.maxZ()), quarry, entity);
        }
        if (flagMinX && flagMinZ) {
            TileQuarry.removeFluidAtPos(targetWorld, new BlockPos(area.minX(), targetPos.m_123342_(), area.minZ()), quarry, entity);
        }
        if (flagMinX && flagMaxZ) {
            TileQuarry.removeFluidAtPos(targetWorld, new BlockPos(area.minX(), targetPos.m_123342_(), area.maxZ()), quarry, entity);
        }
        if (flagMaxX && flagMinZ) {
            TileQuarry.removeFluidAtPos(targetWorld, new BlockPos(area.maxX(), targetPos.m_123342_(), area.minZ()), quarry, entity);
        }
        if (flagMaxX && flagMaxZ) {
            TileQuarry.removeFluidAtPos(targetWorld, new BlockPos(area.maxX(), targetPos.m_123342_(), area.maxZ()), quarry, entity);
        }
    }

    private static void removeFluidAtPos(ServerLevel world, BlockPos pos, TileQuarry quarry, Entity entity) {
        BlockState state = world.m_8055_(pos);
        FluidState fluidState = world.m_6425_(pos);
        if (!fluidState.m_76178_()) {
            Block block = state.m_60734_();
            if (block instanceof BucketPickup) {
                BucketPickup fluidBlock = (BucketPickup)block;
                quarry.useEnergy(PowerManager.getBreakBlockFluidEnergy(quarry), PowerTile.Reason.REMOVE_FLUID, true);
                ItemStack bucketItem = fluidBlock.m_142598_((LevelAccessor)world, pos, state);
                quarry.storage.addFluid(bucketItem);
                if (world.m_8055_(pos).m_60795_() || fluidBlock instanceof LiquidBlock && !fluidState.m_76170_()) {
                    world.m_7731_(pos, Holder.BLOCK_FRAME.getDammingState(), 3);
                }
            } else if (state.m_60734_() instanceof LiquidBlockContainer) {
                float hardness = state.m_60800_((BlockGetter)world, pos);
                quarry.useEnergy(PowerManager.getBreakEnergy(hardness, quarry), PowerTile.Reason.REMOVE_FLUID, true);
                List<ItemStack> drops = InvUtils.getBlockDrops(state, world, pos, world.m_7702_(pos), entity, quarry.getPickaxe());
                drops.forEach(quarry.storage::addItem);
                world.m_7731_(pos, Holder.BLOCK_FRAME.getDammingState(), 3);
            }
        }
    }

    public void setEnchantments(Map<Enchantment, Integer> enchantments) {
        this.setEnchantments(EnchantmentLevel.fromMap(enchantments));
    }

    public void setEnchantments(List<EnchantmentLevel> enchantments) {
        this.enchantments = enchantments;
        this.cache.enchantments.expire();
        this.setMaxEnergy(this.getPowerConfig().maxEnergy() * (long)(this.efficiencyLevel() + 1));
    }

    public void setTileDataFromItem(@Nullable CompoundTag tileData) {
        if (tileData == null) {
            this.digMinY = this.f_58857_ == null ? 0 : this.f_58857_.m_141937_();
            return;
        }
        this.digMinY = tileData.m_128441_("digMinY") ? tileData.m_128451_("digMinY") : (this.f_58857_ == null ? 0 : this.f_58857_.m_141937_());
    }

    public CompoundTag getTileDataForItem() {
        CompoundTag tag = new CompoundTag();
        if (this.digMinY != 0) {
            tag.m_128405_("digMinY", this.digMinY);
        }
        return tag;
    }

    double headSpeed() {
        int l = this.efficiencyLevel();
        return TileQuarry.headSpeed(l);
    }

    @VisibleForTesting
    static double headSpeed(int efficiency) {
        if (efficiency >= 4) {
            return Math.pow(2.0, efficiency - 4);
        }
        return Math.pow(1.681792830507429, efficiency) / 8.0;
    }

    void updateModules() {
        Set blockModules = this.f_58857_ != null ? QuarryModuleProvider.Block.getModulesInWorld(this.f_58857_, this.m_58899_()) : Collections.emptySet();
        Set<QuarryModule> itemModules = Set.copyOf(this.moduleInventory.getModules());
        this.modules = Sets.union(blockModules, itemModules);
        this.itemConverter = this.createConverter();
    }

    BlockState getReplacementState() {
        return this.cache.replaceState.getValue(this.f_58857_);
    }

    public boolean canBreak(Level targetWorld, BlockPos targetPos, BlockState state) {
        boolean result;
        boolean unbreakable;
        if (this.target != null && this.target.alreadySkipped(targetPos)) {
            TraceQuarryWork.canBreakCheck(this, this.m_58899_(), targetPos, state, "Already skipped");
            return false;
        }
        if (state.m_60795_()) {
            TraceQuarryWork.canBreakCheck(this, this.m_58899_(), targetPos, state, "IsAir");
            return true;
        }
        boolean bl = unbreakable = state.m_60800_((BlockGetter)targetWorld, targetPos) < 0.0f;
        if (unbreakable) {
            TraceQuarryWork.canBreakCheck(this, this.m_58899_(), targetPos, state, "Unbreakable block");
            if (this.hasBedrockModule() && state.m_60734_() == Blocks.f_50752_) {
                int worldBottom = targetWorld.m_141937_();
                if (targetWorld.m_46472_().equals((Object)Level.f_46429_)) {
                    return worldBottom < targetPos.m_123342_() && targetPos.m_123342_() < worldBottom + 5 || 122 < targetPos.m_123342_() && targetPos.m_123342_() < this.cache.netherTop.getValue(targetWorld);
                }
                return worldBottom < targetPos.m_123342_() && targetPos.m_123342_() < worldBottom + 5;
            }
            return false;
        }
        if (TileQuarry.isFullFluidBlock(state)) {
            TraceQuarryWork.canBreakCheck(this, this.m_58899_(), targetPos, state, "Is Fluid");
            return this.hasPumpModule();
        }
        boolean bl2 = result = this.getReplacementState() != state;
        if (!result) {
            TraceQuarryWork.canBreakCheck(this, this.m_58899_(), targetPos, state, "Replacement state");
        }
        return result;
    }

    @Override
    public List<? extends Component> getDebugLogs() {
        return Stream.of("%sArea:%s %s".formatted(ChatFormatting.GREEN, ChatFormatting.RESET, this.area), "%sTarget:%s %s".formatted(ChatFormatting.GREEN, ChatFormatting.RESET, this.target), "%sState:%s %s".formatted(new Object[]{ChatFormatting.GREEN, ChatFormatting.RESET, this.state}), "%sRemoveBedrock:%s %s".formatted(ChatFormatting.GREEN, ChatFormatting.RESET, this.hasBedrockModule()), "%sDigMinY:%s %d".formatted(ChatFormatting.GREEN, ChatFormatting.RESET, this.digMinY), "%sHead:%s (%.1f, %.1f, %.1f)".formatted(ChatFormatting.GREEN, ChatFormatting.RESET, this.headX, this.headY, this.headZ), "%sModules:%s %s".formatted(ChatFormatting.GREEN, ChatFormatting.RESET, this.modules), "%sProgressY:%s %.2f".formatted(ChatFormatting.GREEN, ChatFormatting.RESET, this.yProgress()), "%sCurrentWorkProgress:%s %.2f".formatted(ChatFormatting.GREEN, ChatFormatting.RESET, this.xzProgress()), this.energyString()).map(Component::m_237113_).toList();
    }

    private double yProgress() {
        int totalY = this.m_58899_().m_123342_() - this.digMinY;
        int currentY = Optional.ofNullable(this.target).map(t -> t.get(false)).map(Vec3i::m_123342_).orElse(this.m_58899_().m_123342_());
        return (double)(this.m_58899_().m_123342_() - currentY) / (double)totalY;
    }

    private double xzProgress() {
        if (this.target != null) {
            return this.target.progress();
        }
        return 0.0;
    }

    @Override
    public MachineStorage getStorage() {
        return this.storage;
    }

    @Override
    public List<EnchantmentLevel> getEnchantments() {
        return Collections.unmodifiableList(this.enchantments);
    }

    public void sync() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            PacketHandler.sendToClient(new ClientSyncMessage(this), this.f_58857_);
        }
    }

    public AABB getRenderBoundingBox() {
        if (this.area != null) {
            int min = this.f_58857_ != null ? this.f_58857_.m_141937_() : 0;
            return new AABB((double)this.area.minX(), (double)min, (double)this.area.minZ(), (double)this.area.maxX(), (double)this.area.maxY(), (double)this.area.maxZ());
        }
        return new AABB(this.m_58899_(), this.m_58899_().m_7918_(1, 1, 1));
    }

    @Override
    public ModuleInventory getModuleInventory() {
        return this.moduleInventory;
    }

    @Override
    public Set<QuarryModule> getLoadedModules() {
        return this.modules;
    }

    ItemConverter createConverter() {
        return this.getFilterModules().map(FilterModule::createConverter).reduce(ItemConverter.defaultConverter(), ItemConverter::combined);
    }

    @Override
    public int efficiencyLevel() {
        return this.cache.enchantments.getValue(this.m_58904_()).efficiency();
    }

    @Override
    public int unbreakingLevel() {
        return this.cache.enchantments.getValue(this.m_58904_()).unbreaking();
    }

    @Override
    public int fortuneLevel() {
        return this.cache.enchantments.getValue(this.m_58904_()).fortune();
    }

    @Override
    public int silktouchLevel() {
        return this.cache.enchantments.getValue(this.m_58904_()).silktouch();
    }

    static boolean shouldLogQuarryWork() {
        return TraceQuarryWork.enabled;
    }

    private class QuarryCache {
        final CacheEntry<BlockState> replaceState = CacheEntry.supplierCache(5L, () -> TileQuarry.this.getReplacerModule().map(ReplacerModule::getState).orElse(Blocks.f_50016_.m_49966_()));
        final CacheEntry<Integer> netherTop;
        final CacheEntry<EnchantmentHolder> enchantments;

        public QuarryCache() {
            this.netherTop = CacheEntry.supplierCache(100L, QuarryPlus.config.common.netherTop);
            this.enchantments = CacheEntry.supplierCache(1000L, () -> EnchantmentHolder.makeHolder(TileQuarry.this));
        }
    }
}

