/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.module;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.yogpc.qp.Holder;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.QPItem;
import com.yogpc.qp.machines.module.ModuleInventory;
import com.yogpc.qp.machines.module.QuarryModuleProvider;
import com.yogpc.qp.machines.module.ReplacerModule;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReplacerModuleItem
extends QPItem
implements QuarryModuleProvider.Item {
    public static final String NAME = "replacer_module";
    public static final String KEY_STATE = "state";

    public ReplacerModuleItem() {
        super(new ResourceLocation("quarryplus", NAME), new Item.Properties());
    }

    @Override
    public ReplacerModule getModule(@NotNull ItemStack stack) {
        BlockState state = Optional.ofNullable(stack.m_41737_(KEY_STATE)).flatMap(this::getStateFromTag).orElse(Holder.BLOCK_DUMMY_REPLACER.m_49966_());
        return new ReplacerModule(state);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        if (!context.m_43725_().f_46443_) {
            if (context.m_43723_() != null && context.m_43723_().m_6144_()) {
                stack.m_41749_(KEY_STATE);
                context.m_43723_().m_5661_((Component)Component.m_237113_((String)"Replacer Module: Setting removed."), false);
            } else {
                if (context.m_43725_().m_7702_(context.m_8083_()) instanceof ModuleInventory.HasModuleInventory) {
                    return InteractionResult.PASS;
                }
                BlockState state = context.m_43725_().m_8055_(context.m_8083_());
                if (ReplacerModule.rejects.stream().anyMatch(t -> t.test(state))) {
                    return InteractionResult.PASS;
                }
                BlockState.f_61039_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)state).resultOrPartial(s -> {
                    stack.m_41749_(KEY_STATE);
                    QuarryPlus.LOGGER.warn("Error in encoding state to NBT. {}, {}", (Object)state, s);
                }).ifPresent(stateTag -> stack.m_41700_(KEY_STATE, stateTag));
                if (context.m_43723_() != null) {
                    context.m_43723_().m_5661_((Component)Component.m_237110_((String)"quarryplus.chat.replacer_module", (Object[])new Object[]{state.m_60734_().m_49954_()}), false);
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        super.m_7373_(stack, level, list, flag);
        Optional.ofNullable(stack.m_41737_(KEY_STATE)).flatMap(tag -> BlockState.f_61039_.parse((DynamicOps)NbtOps.f_128958_, tag).result()).ifPresent(state -> {
            list.add((Component)state.m_60734_().m_49954_());
            state.m_61148_().forEach((k, v) -> list.add((Component)Component.m_237113_((String)String.format("  %s: %s", k.m_61708_(), v))));
        });
    }

    Optional<BlockState> getStateFromTag(CompoundTag tag) {
        try {
            Predicate<BlockState> accept = ReplacerModule.rejects.stream().reduce(s -> false, Predicate::or).negate();
            DataResult result = BlockState.f_61039_.parse((DynamicOps)NbtOps.f_128958_, (Object)tag);
            return result.result().filter(accept);
        }
        catch (Exception e) {
            QuarryPlus.LOGGER.debug("Error in getting replace block of ReplacerModule.", (Throwable)e);
            return Optional.empty();
        }
    }
}

