/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.ChunkPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record Area(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, Direction direction) implements Serializable
{
    private static final long serialVersionUID = 1L;

    public Area {
        if (minX > maxX) {
            throw new IllegalArgumentException("MinX(%d) must be less than or equal to MaxX(%d)".formatted(minX, maxX));
        }
        if (minY > maxY) {
            throw new IllegalArgumentException("MinY(%d) must be less than or equal to MaxY(%d)".formatted(minY, maxY));
        }
        if (minZ > maxZ) {
            throw new IllegalArgumentException("MinZ(%d) must be less than or equal to MaxZ(%d)".formatted(minZ, maxZ));
        }
    }

    public Area(Vec3i pos1, Vec3i pos2, Direction direction) {
        this(Math.min(pos1.m_123341_(), pos2.m_123341_()), Math.min(pos1.m_123342_(), pos2.m_123342_()), Math.min(pos1.m_123343_(), pos2.m_123343_()), Math.max(pos1.m_123341_(), pos2.m_123341_()), Math.max(pos1.m_123342_(), pos2.m_123342_()), Math.max(pos1.m_123343_(), pos2.m_123343_()), direction);
    }

    public Area assureY(int minSpaceY) {
        int space = this.maxY - this.minY;
        if (space >= minSpaceY) {
            return this;
        }
        return new Area(this.minX, this.minY, this.minZ, this.maxX, this.minY + minSpaceY, this.maxZ, this.direction);
    }

    public Area aboveY(int minY) {
        if (this.minY < minY && minY <= this.maxY) {
            return new Area(this.minX, minY, this.minZ, this.maxX, this.maxY, this.maxZ, this.direction);
        }
        return this;
    }

    public Area shrink(int x, int y, int z) {
        int x1 = this.minX + x;
        int x2 = this.maxX - x;
        int y1 = this.minY + y;
        int y2 = this.maxY - y;
        int z1 = this.minZ + z;
        int z2 = this.maxZ - z;
        return new Area(Math.min(x1, x2), Math.min(y1, y2), Math.min(z1, z2), Math.max(x1, x2), Math.max(y1, y2), Math.max(z1, z2), this.direction);
    }

    public boolean isInAreaIgnoreY(Vec3i vec3i) {
        return this.minX < vec3i.m_123341_() && vec3i.m_123341_() < this.maxX && this.minZ < vec3i.m_123343_() && vec3i.m_123343_() < this.maxZ;
    }

    public boolean isRangeInLimit(int limit, boolean isAdvQuarry) {
        if (limit <= 0) {
            return true;
        }
        int offset = isAdvQuarry ? 2 : 0;
        return this.maxX - this.minX - offset <= limit && this.maxZ - this.minZ - offset <= limit;
    }

    public int sizeOfEachY() {
        return (this.maxX() - this.minX()) * (this.maxZ() - this.minZ());
    }

    public CompoundTag toNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("minX", this.minX);
        tag.m_128405_("minY", this.minY);
        tag.m_128405_("minZ", this.minZ);
        tag.m_128405_("maxX", this.maxX);
        tag.m_128405_("maxY", this.maxY);
        tag.m_128405_("maxZ", this.maxZ);
        tag.m_128359_("direction", this.direction.m_122433_());
        return tag;
    }

    public static Optional<Area> fromNBT(@Nullable CompoundTag tag) {
        if (tag == null || tag.m_128456_()) {
            return Optional.empty();
        }
        return Optional.of(new Area(tag.m_128451_("minX"), tag.m_128451_("minY"), tag.m_128451_("minZ"), tag.m_128451_("maxX"), tag.m_128451_("maxY"), tag.m_128451_("maxZ"), Direction.m_122402_((String)tag.m_128461_("direction"))));
    }

    @NotNull
    public static Stream<BlockPos> getFramePosStream(@NotNull Area area) {
        return Stream.of(Area.makeSquare(area, area.minY()), Area.makePole(area, area.minY() + 1, area.maxY()), Area.makeSquare(area, area.maxY())).flatMap(Function.identity());
    }

    static IntStream to(int first, int endInclusive) {
        if (first < endInclusive) {
            return IntStream.rangeClosed(first, endInclusive);
        }
        if (first > endInclusive) {
            return IntStream.iterate(first, i -> i >= endInclusive, i -> i - 1);
        }
        return IntStream.of(first);
    }

    static Stream<BlockPos> makeSquare(Area area, int y) {
        return Stream.of(Area.to(area.minX(), area.maxX()).mapToObj(x -> new BlockPos(x, y, area.minZ())), Area.to(area.minZ(), area.maxZ()).mapToObj(z -> new BlockPos(area.maxX(), y, z)), Area.to(area.maxX(), area.minX()).mapToObj(x -> new BlockPos(x, y, area.maxZ())), Area.to(area.maxZ(), area.minZ()).mapToObj(z -> new BlockPos(area.minX(), y, z))).flatMap(Function.identity());
    }

    static Stream<BlockPos> makePole(Area area, int yMin, int yMax) {
        return Area.to(yMin, yMax).boxed().flatMap(y -> Stream.of(new BlockPos(area.minX(), y.intValue(), area.minZ()), new BlockPos(area.maxX(), y.intValue(), area.minZ()), new BlockPos(area.maxX(), y.intValue(), area.maxZ()), new BlockPos(area.minX(), y.intValue(), area.maxZ())));
    }

    public List<ChunkPos> getChunkPosList() {
        ArrayList<ChunkPos> posList = new ArrayList<ChunkPos>();
        for (int x = Math.floorDiv(this.minX, 16); x <= Math.floorDiv(this.maxX, 16); ++x) {
            for (int z = Math.floorDiv(this.minZ, 16); z <= Math.floorDiv(this.maxZ, 16); ++z) {
                posList.add(new ChunkPos(x, z));
            }
        }
        return posList;
    }
}

