/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.integration.rei;

import com.yogpc.qp.Holder;
import com.yogpc.qp.integration.rei.QuarryReiPlugin;
import com.yogpc.qp.integration.rei.WorkbenchDisplay;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.ItemLike;

final class WorkbenchCategory
implements DisplayCategory<WorkbenchDisplay> {
    WorkbenchCategory() {
    }

    public CategoryIdentifier<? extends WorkbenchDisplay> getCategoryIdentifier() {
        return QuarryReiPlugin.WORKBENCH;
    }

    public List<Widget> setupDisplay(WorkbenchDisplay display, Rectangle bounds) {
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        widgets.add((Widget)Widgets.createRecipeBase((Rectangle)bounds));
        int offset = 4;
        List inputs = display.getInputEntries();
        for (int i = 0; i < inputs.size(); ++i) {
            EntryIngredient ingredient = (EntryIngredient)inputs.get(i);
            int x = 18 * (i % 9) + bounds.x + offset;
            int y = 18 * (i / 9) + bounds.y + offset;
            Slot slot = Widgets.createSlot((Point)new Point(x, y)).entries((Collection)ingredient).markInput();
            widgets.add((Widget)slot);
        }
        widgets.add(Widgets.createResultSlotBackground((Point)new Point(bounds.getCenterX() - 9, bounds.getMaxY() - 18 - offset * 2)));
        Slot output = Widgets.createSlot((Point)new Point(bounds.getCenterX() - 9, bounds.getMaxY() - 18 - offset * 2)).entries((Collection)display.getOutputEntries().get(0)).markOutput().disableBackground();
        widgets.add((Widget)output);
        widgets.add((Widget)Widgets.createLabel((Point)new Point(bounds.x + offset, bounds.getMaxY() - 18 - offset * 2), (Component)Component.m_237113_((String)"%d FE".formatted(display.energy / 1000000000L))).leftAligned());
        return widgets;
    }

    public Component getTitle() {
        return Holder.BLOCK_WORKBENCH.m_49954_();
    }

    public Renderer getIcon() {
        return EntryStacks.of((ItemLike)Holder.BLOCK_WORKBENCH);
    }

    public int getDisplayHeight() {
        return 66;
    }

    public int getDisplayWidth(WorkbenchDisplay display) {
        return 168;
    }
}

